/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.annotations.FieldWriter;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.TransientRelationship;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.DefaultRequest;
import org.neo4j.ogm.session.request.RowStatementFactory;
import org.neo4j.ogm.transaction.Transaction;

public class RequestExecutor {
    private Neo4jSession session;

    public RequestExecutor(Neo4jSession session) {
        this.session = session;
    }

    public void executeSave(CompileContext context) {
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        ArrayList<ReferenceMapping> entityReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<ReferenceMapping> relReferenceMappings = new ArrayList<ReferenceMapping>();
        if (compiler.hasStatementsDependentOnNewNodes()) {
            boolean manageTransaction = false;
            Transaction tx = this.session.getTransaction();
            if (tx == null) {
                tx = this.session.beginTransaction();
                manageTransaction = true;
            }
            DefaultRequest createNodesRowRequest = new DefaultRequest();
            createNodesRowRequest.setStatements(compiler.createNodesStatements());
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)createNodesRowRequest);){
                this.registerNewEntityIds(context, (Response<RowModel>)response, entityReferenceMappings);
            }
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.addAll(compiler.createRelationshipsStatements());
            statements.addAll(compiler.updateNodesStatements());
            statements.addAll(compiler.updateRelationshipStatements());
            statements.addAll(compiler.deleteRelationshipStatements());
            statements.addAll(compiler.deleteRelationshipEntityStatements());
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(statements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
            }
            if (manageTransaction) {
                tx.commit();
            }
        } else {
            List statements = compiler.getAllStatements();
            if (statements.size() > 0) {
                DefaultRequest defaultRequest = new DefaultRequest();
                defaultRequest.setStatements(statements);
                try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                    this.registerNewEntityIds(context, (Response<RowModel>)response, entityReferenceMappings);
                    this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
                }
            }
        }
        this.updateEntities(context, this.session, entityReferenceMappings);
        this.updateEntities(context, this.session, relReferenceMappings);
        this.updateRelationships(context, this.session, relReferenceMappings);
    }

    public void executeSave(List<CompileContext> contexts) {
        ArrayList<ReferenceMapping> entityReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<ReferenceMapping> relReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        boolean manageTransaction = false;
        Transaction tx = this.session.getTransaction();
        if (tx == null) {
            tx = this.session.beginTransaction();
            manageTransaction = true;
        }
        for (CompileContext context : contexts) {
            Compiler compiler = context.getCompiler();
            compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
            if (compiler.hasStatementsDependentOnNewNodes()) {
                DefaultRequest createNodesRowRequest = new DefaultRequest();
                createNodesRowRequest.setStatements(compiler.createNodesStatements());
                try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)createNodesRowRequest);){
                    this.registerNewEntityIds(context, (Response<RowModel>)response, entityReferenceMappings);
                }
                statements.addAll(compiler.createRelationshipsStatements());
                statements.addAll(compiler.updateNodesStatements());
                statements.addAll(compiler.updateRelationshipStatements());
                statements.addAll(compiler.deleteRelationshipStatements());
                statements.addAll(compiler.deleteRelationshipEntityStatements());
                continue;
            }
            statements.addAll(compiler.getAllStatements());
        }
        if (statements.size() > 0) {
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(statements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
            }
        }
        if (manageTransaction) {
            tx.commit();
        }
        for (CompileContext context : contexts) {
            this.updateEntities(context, this.session, entityReferenceMappings);
            this.updateEntities(context, this.session, relReferenceMappings);
            this.updateRelationships(context, this.session, relReferenceMappings);
        }
    }

    private void registerNewEntityIds(CompileContext context, Response<RowModel> response, List<ReferenceMapping> entityRefMappings) {
        RowModel rowModel;
        while ((rowModel = (RowModel)response.next()) != null) {
            Object[] results = rowModel.getValues();
            Long entityRef = ((Number)results[0]).longValue();
            Long entityId = ((Number)results[1]).longValue();
            entityRefMappings.add(new ReferenceMapping(entityRef, entityId));
            context.registerNewNodeId(entityRef, entityId);
        }
    }

    private void registerNewRelIds(Response<RowModel> response, List<ReferenceMapping> relRefMappings) {
        RowModel rowModel;
        while ((rowModel = (RowModel)response.next()) != null) {
            Object[] results = rowModel.getValues();
            Long relRef = ((Number)results[0]).longValue();
            Long relId = ((Number)results[1]).longValue();
            relRefMappings.add(new ReferenceMapping(relRef, relId));
        }
    }

    private void updateEntities(CompileContext context, Neo4jSession session, List<ReferenceMapping> entityRefMappings) {
        for (ReferenceMapping referenceMapping : entityRefMappings) {
            Object persisted = context.getNewObject(referenceMapping.ref);
            RequestExecutor.registerEntity(referenceMapping.id, persisted, session);
        }
    }

    private void updateRelationships(CompileContext context, Neo4jSession session, List<ReferenceMapping> relRefMappings) {
        for (ReferenceMapping referenceMapping : relRefMappings) {
            for (Object obj : context.registry()) {
                if (!(obj instanceof TransientRelationship)) continue;
                TransientRelationship transientRelationship = (TransientRelationship)obj;
                if (!referenceMapping.ref.equals(transientRelationship.getRef())) continue;
                MappedRelationship mappedRelationship = new MappedRelationship(context.newNodeId(transientRelationship.getSrc()), transientRelationship.getRel(), context.newNodeId(transientRelationship.getTgt()), transientRelationship.getSrcClass(), transientRelationship.getTgtClass());
                if (session.context().getRelationshipEntity(referenceMapping.id) != null) {
                    mappedRelationship.setRelationshipId(referenceMapping.id);
                }
                session.context().mappedRelationships().add(mappedRelationship);
            }
        }
    }

    private static void registerEntity(Long identity, Object persisted, Neo4jSession session) {
        MappingContext mappingContext = session.context();
        if (persisted != null) {
            ClassInfo classInfo = session.metaData().classInfo(persisted);
            Field identityField = classInfo.getField(classInfo.identityField());
            FieldWriter.write(identityField, persisted, identity);
            if (classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null) {
                mappingContext.registerNodeEntity(persisted, identity);
            } else {
                mappingContext.registerRelationshipEntity(persisted, identity);
            }
            mappingContext.remember(persisted);
        }
    }

    class ReferenceMapping {
        private Long ref;
        private Long id;

        ReferenceMapping(Long ref, Long id) {
            this.ref = ref;
            this.id = id;
        }
    }
}

