/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.ogm.annotations.FieldWriter;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;

public class LoadByInstancesDelegate
implements Capability.LoadByInstances {
    private final Neo4jSession session;

    public LoadByInstancesDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination, int depth) {
        if (objects == null || objects.isEmpty()) {
            return objects;
        }
        HashSet<Long> ids = new HashSet<Long>();
        Class<?> type = objects.iterator().next().getClass();
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        Field identityField = classInfo.getField(classInfo.identityField());
        for (T o : objects) {
            ids.add((Long)FieldWriter.read(identityField, o));
        }
        return this.session.loadAll(type, ids, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects) {
        return this.loadAll(objects, new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        return this.loadAll(objects, new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder) {
        return this.loadAll(objects, sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, int depth) {
        return this.loadAll(objects, sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination) {
        return this.loadAll(objects, new SortOrder(), pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination, int depth) {
        return this.loadAll(objects, new SortOrder(), pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(objects, sortOrder, pagination, 1);
    }
}

