/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.ConstantPool;

public class AnnotationInfo {
    private String annotationName;
    private final Map<String, String> elements = new HashMap<String, String>();

    public AnnotationInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        String annotationFieldDescriptor = constantPool.lookup(dataInputStream.readUnsignedShort());
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        this.setName(annotationClassName);
        int numElementValuePairs = dataInputStream.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            String elementName = constantPool.lookup(dataInputStream.readUnsignedShort());
            Object value = this.readAnnotationElementValue(dataInputStream, constantPool);
            if (elementName == null || value == null) continue;
            this.put(elementName, value.toString());
        }
    }

    public String getName() {
        return this.annotationName;
    }

    void setName(String annotationName) {
        this.annotationName = annotationName;
    }

    void put(String key, String value) {
        this.elements.put(key, value);
    }

    public String get(String key, String defaultValue) {
        if (this.elements.get(key) == null) {
            this.put(key, defaultValue);
        }
        return this.elements.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.annotationName);
        sb.append(": ");
        for (String key : this.elements.keySet()) {
            sb.append(key);
            sb.append(":'");
            sb.append(this.get(key, null));
            sb.append("'");
            sb.append(" ");
        }
        return sb.toString();
    }

    private Object readAnnotationElementValue(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int tag = dataInputStream.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return constantPool.lookup(dataInputStream.readUnsignedShort());
            }
            case 101: {
                dataInputStream.skipBytes(4);
                return null;
            }
            case 99: {
                return constantPool.lookup(dataInputStream.readUnsignedShort());
            }
            case 64: {
                return new AnnotationInfo(dataInputStream, constantPool);
            }
            case 91: {
                int count = dataInputStream.readUnsignedShort();
                Object[] values = new Object[count];
                for (int l = 0; l < count; ++l) {
                    values[l] = this.readAnnotationElementValue(dataInputStream, constantPool);
                }
                return values;
            }
        }
        throw new ClassFormatError("Invalid annotation element type tag: 0x" + Integer.toHexString(tag));
    }
}

