/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.annotations.DefaultEntityAccessStrategy;
import org.neo4j.ogm.annotations.EntityAccessStrategy;
import org.neo4j.ogm.annotations.PropertyReader;
import org.neo4j.ogm.annotations.RelationalReader;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.context.EntityMemo;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.metadata.ClassInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingContext {
    private final Logger logger = LoggerFactory.getLogger(MappingContext.class);
    private final ConcurrentMap<Long, Object> relationshipEntityRegister = new ConcurrentHashMap<Long, Object>();
    private final ConcurrentMap<Long, Object> nodeEntityRegister = new ConcurrentHashMap<Long, Object>();
    private final Set<MappedRelationship> relationshipRegister = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<Class<?>, Map<Long, Object>> typeRegister = new ConcurrentHashMap();
    private final EntityMemo objectMemo;
    private final MetaData metaData;
    private final EntityAccessStrategy entityAccessStrategy = new DefaultEntityAccessStrategy();

    public MappingContext(MetaData metaData) {
        this.metaData = metaData;
        this.objectMemo = new EntityMemo(metaData);
    }

    public Object getNodeEntity(Long id) {
        return this.nodeEntityRegister.get(id);
    }

    public Object registerNodeEntity(Object entity, Long id) {
        this.nodeEntityRegister.putIfAbsent(id, entity);
        entity = this.nodeEntityRegister.get(id);
        this.registerTypes(entity.getClass(), entity, id);
        return entity;
    }

    private void registerTypes(Class type, Object entity, Long id) {
        this.getAll(type).put(id, entity);
        if (type.getSuperclass() != null && this.metaData != null && this.metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            this.registerTypes(type.getSuperclass(), entity, id);
        }
        if (type.getInterfaces() != null && this.metaData != null) {
            for (Class<?> interfaceClass : type.getInterfaces()) {
                if (this.metaData.classInfo(interfaceClass.getName()) == null) continue;
                this.registerTypes(interfaceClass, entity, id);
            }
        }
    }

    private void deregisterTypes(Class type, Long id) {
        Map entities = (Map)this.typeRegister.get(type);
        if (entities != null && type.getSuperclass() != null && this.metaData != null && this.metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            entities.remove(id);
            this.deregisterTypes(type.getSuperclass(), id);
        }
    }

    public void deregister(Object entity, Long id) {
        this.deregisterTypes(entity.getClass(), id);
        this.nodeEntityRegister.remove(id);
        this.deregisterDependentRelationshipEntity(entity);
    }

    public void replace(Object entity, Long id) {
        this.nodeEntityRegister.remove(id);
        this.registerNodeEntity(entity, id);
        this.remember(entity);
    }

    public Map<Long, Object> getAll(Class<?> type) {
        Map objectList = (Map)this.typeRegister.get(type);
        if (objectList == null) {
            this.typeRegister.putIfAbsent(type, Collections.synchronizedMap(new HashMap()));
            objectList = (Map)this.typeRegister.get(type);
        }
        return objectList;
    }

    public void remember(Object entity) {
        Object id = this.entityAccessStrategy.getIdentityPropertyReader(this.metaData.classInfo(entity)).read(entity);
        assert (id != null);
        this.objectMemo.remember((Long)id, entity, this.metaData.classInfo(entity));
    }

    public boolean isDirty(Object entity) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        Object id = this.entityAccessStrategy.getIdentityPropertyReader(classInfo).read(entity);
        return !this.objectMemo.remembered((Long)id, entity, classInfo);
    }

    public boolean isRegisteredRelationship(MappedRelationship relationship) {
        return this.relationshipRegister.contains(relationship);
    }

    public Set<MappedRelationship> mappedRelationships() {
        return this.relationshipRegister;
    }

    public void registerRelationship(MappedRelationship relationship) {
        if (relationship.getRelationshipId() != null && this.relationshipEntityRegister.get(relationship.getRelationshipId()) == null) {
            relationship.setRelationshipId(null);
        }
        this.relationshipRegister.add(relationship);
    }

    public void clear() {
        this.objectMemo.clear();
        this.relationshipRegister.clear();
        this.nodeEntityRegister.clear();
        this.typeRegister.clear();
        this.relationshipEntityRegister.clear();
    }

    public Object getRelationshipEntity(Long relationshipId) {
        return this.relationshipEntityRegister.get(relationshipId);
    }

    public Object registerRelationshipEntity(Object relationshipEntity, Long id) {
        this.relationshipEntityRegister.putIfAbsent(id, relationshipEntity);
        this.registerTypes(relationshipEntity.getClass(), relationshipEntity, id);
        return relationshipEntity;
    }

    public void clear(Class<?> type) {
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        if (classInfo.isInterface()) {
            List<ClassInfo> implementingClasses = this.metaData.getImplementingClassInfos(classInfo.name());
            for (ClassInfo implementingClass : implementingClasses) {
                try {
                    String implementingClassName = implementingClass.name();
                    this.clear(MetaDataClassLoader.loadClass((String)implementingClassName));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            PropertyReader identityReader = this.entityAccessStrategy.getIdentityPropertyReader(classInfo);
            this.clear(type, identityReader);
        }
    }

    private void deregisterDependentRelationshipEntity(Object startOrEndEntity) {
        Iterator relationshipEntityIdIterator = this.relationshipEntityRegister.keySet().iterator();
        while (relationshipEntityIdIterator.hasNext()) {
            Long relationshipEntityId = (Long)relationshipEntityIdIterator.next();
            Object relationshipEntity = this.relationshipEntityRegister.get(relationshipEntityId);
            RelationalReader startNodeReader = this.entityAccessStrategy.getStartNodeReader(this.metaData.classInfo(relationshipEntity));
            RelationalReader endNodeReader = this.entityAccessStrategy.getEndNodeReader(this.metaData.classInfo(relationshipEntity));
            if (startOrEndEntity != startNodeReader.read(relationshipEntity) && startOrEndEntity != endNodeReader.read(relationshipEntity)) continue;
            relationshipEntityIdIterator.remove();
        }
    }

    private void clear(Class<?> type, PropertyReader identityReader) {
        for (Object entity : this.getAll(type).values()) {
            this.purge(entity, identityReader, type);
        }
        this.getAll(type).clear();
    }

    public void clear(Object entity) {
        Class<?> type = entity.getClass();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        PropertyReader identityReader = this.entityAccessStrategy.getIdentityPropertyReader(classInfo);
        this.purge(entity, identityReader, type);
        Long id = (Long)identityReader.read(entity);
        if (id != null) {
            this.getAll(type).remove(id);
        }
    }

    private void purge(Object entity, PropertyReader identityReader, Class type) {
        Long id = (Long)identityReader.read(entity);
        if (id != null) {
            if (this.nodeEntityRegister.containsKey(id)) {
                this.nodeEntityRegister.remove(id);
                Iterator<MappedRelationship> mappedRelationshipIterator = this.mappedRelationships().iterator();
                while (mappedRelationshipIterator.hasNext()) {
                    MappedRelationship mappedRelationship = mappedRelationshipIterator.next();
                    if (mappedRelationship.getStartNodeId() != id.longValue() && mappedRelationship.getEndNodeId() != id.longValue()) continue;
                    mappedRelationshipIterator.remove();
                }
            }
            if (this.metaData.isRelationshipEntity(type.getName()) && this.relationshipEntityRegister.containsKey(id)) {
                this.relationshipEntityRegister.remove(id);
                RelationalReader startNodeReader = this.entityAccessStrategy.getStartNodeReader(this.metaData.classInfo(entity));
                this.clear(startNodeReader.read(entity));
                RelationalReader endNodeReader = this.entityAccessStrategy.getEndNodeReader(this.metaData.classInfo(entity));
                this.clear(endNodeReader.read(entity));
            }
        }
    }
}

