/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.ClassUtils;
import org.neo4j.ogm.EntityUtils;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotations.DefaultEntityAccessStrategy;
import org.neo4j.ogm.annotations.EntityAccess;
import org.neo4j.ogm.annotations.EntityAccessStrategy;
import org.neo4j.ogm.annotations.EntityFactory;
import org.neo4j.ogm.annotations.FieldWriter;
import org.neo4j.ogm.annotations.PropertyReader;
import org.neo4j.ogm.annotations.PropertyWriter;
import org.neo4j.ogm.annotations.RelationalReader;
import org.neo4j.ogm.annotations.RelationalWriter;
import org.neo4j.ogm.context.EntityCollector;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.exception.BaseClassNotFoundException;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphEntityMapper
implements ResponseMapper<GraphModel> {
    private final Logger logger = LoggerFactory.getLogger(GraphEntityMapper.class);
    private final MappingContext mappingContext;
    private final EntityFactory entityFactory;
    private final MetaData metadata;
    private final EntityAccessStrategy entityAccessStrategy;

    public GraphEntityMapper(MetaData metaData, MappingContext mappingContext) {
        this.metadata = metaData;
        this.entityFactory = new EntityFactory(this.metadata);
        this.mappingContext = mappingContext;
        this.entityAccessStrategy = new DefaultEntityAccessStrategy();
    }

    public <T> Iterable<T> map(Class<T> type, Response<GraphModel> model) {
        GraphModel graphModel;
        ArrayList<T> objects = new ArrayList<T>();
        ArrayList<Long> objectIds = new ArrayList<Long>();
        while ((graphModel = (GraphModel)model.next()) != null) {
            List<T> mappedEntities = this.map(type, graphModel);
            for (T entity : mappedEntities) {
                Long identity = EntityUtils.identity(entity, this.metadata);
                if (objectIds.contains(identity)) continue;
                objects.add(entity);
                objectIds.add(identity);
            }
        }
        model.close();
        return objects;
    }

    public Map<Long, Object> mapRelationships(GraphModel model) {
        HashMap<Long, Object> results = new HashMap<Long, Object>();
        LinkedHashSet<Long> edgeIds = new LinkedHashSet<Long>();
        this.mapRelationships(model, edgeIds);
        for (Long id : edgeIds) {
            Object o = this.mappingContext.getRelationshipEntity(id);
            if (o == null) continue;
            results.put(id, o);
        }
        return results;
    }

    public <T> List<T> map(Class<T> type, GraphModel graphModel) {
        Object o;
        LinkedHashSet<Long> nodeIds = new LinkedHashSet<Long>();
        LinkedHashSet<Long> edgeIds = new LinkedHashSet<Long>();
        this.mapEntities(type, graphModel, nodeIds, edgeIds);
        ArrayList<T> results = new ArrayList<T>();
        for (Long id : nodeIds) {
            o = this.mappingContext.getNodeEntity(id);
            if (o == null || !type.isAssignableFrom(o.getClass())) continue;
            results.add(type.cast(o));
        }
        if (results.isEmpty()) {
            for (Long id : edgeIds) {
                o = this.mappingContext.getRelationshipEntity(id);
                if (o == null || !type.isAssignableFrom(o.getClass())) continue;
                results.add(type.cast(o));
            }
        }
        return results;
    }

    private <T> void mapEntities(Class<T> type, GraphModel graphModel, Set<Long> nodeIds, Set<Long> edgeIds) {
        try {
            this.mapNodes(graphModel, nodeIds);
            this.mapRelationships(graphModel, edgeIds);
        }
        catch (Exception e) {
            throw new MappingException("Error mapping GraphModel to instance of " + type.getName(), e);
        }
    }

    private void mapNodes(GraphModel graphModel, Set<Long> nodeIds) {
        for (Node node : graphModel.getNodes()) {
            Object entity = this.mappingContext.getNodeEntity(node.getId());
            try {
                if (entity == null) {
                    entity = this.mappingContext.registerNodeEntity(this.entityFactory.newObject(node), node.getId());
                }
                this.setIdentity(entity, node.getId());
                this.setProperties(node, entity);
                this.mappingContext.remember(entity);
                nodeIds.add(node.getId());
            }
            catch (BaseClassNotFoundException e) {
                this.logger.debug(e.getMessage());
            }
        }
    }

    private void setIdentity(Object instance, Long id) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        FieldInfo fieldInfo = classInfo.identityField();
        FieldWriter.write(classInfo.getField(fieldInfo), instance, id);
    }

    private void setProperties(Node nodeModel, Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        for (Property property : nodeModel.getPropertyList()) {
            this.writeProperty(classInfo, instance, property);
        }
    }

    private void setProperties(Edge relationshipModel, Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        for (Property property : relationshipModel.getPropertyList()) {
            this.writeProperty(classInfo, instance, property);
        }
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Property<?, ?> property) {
        PropertyWriter writer = this.entityAccessStrategy.getPropertyWriter(classInfo, property.getKey().toString());
        if (writer == null) {
            this.logger.debug("Unable to find property: {} on class: {} for writing", property.getKey(), (Object)classInfo.name());
        } else {
            PropertyReader reader;
            Object value = property.getValue();
            if ((writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) && (reader = this.entityAccessStrategy.getPropertyReader(classInfo, property.getKey().toString())) != null) {
                Object currentValue = reader.read(instance);
                Class<?> paramType = writer.type();
                value = paramType.isArray() ? EntityAccess.merge(paramType, (Iterable)value, (Object[])currentValue) : EntityAccess.merge(paramType, (Iterable)value, (Iterable)currentValue);
            }
            writer.write(instance, value);
        }
    }

    private boolean tryMappingAsSingleton(Object source, Object parameter, Edge edge, String relationshipDirection) {
        String edgeLabel = edge.getType();
        ClassInfo sourceInfo = this.metadata.classInfo(source);
        RelationalWriter writer = this.entityAccessStrategy.getRelationalWriter(sourceInfo, edgeLabel, relationshipDirection, parameter);
        if (writer != null && writer.forScalar()) {
            writer.write(source, parameter);
            return true;
        }
        return false;
    }

    private void mapRelationships(GraphModel graphModel, Set<Long> edgeIds) {
        ArrayList<Edge> oneToMany = new ArrayList<Edge>();
        for (Edge edge : graphModel.getRelationships()) {
            Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
            edgeIds.add(edge.getId());
            if (source != null && target != null) {
                ClassInfo relationshipEntityClassInfo = this.getRelationshipEntity(edge);
                if (relationshipEntityClassInfo != null) {
                    this.mapRelationshipEntity(oneToMany, edge, source, target, relationshipEntityClassInfo);
                    continue;
                }
                this.mapRelationship(oneToMany, edge, source, target);
                continue;
            }
            this.logger.debug("Relationship {} cannot be hydrated because one or more required node types are not mapped to entity classes", (Object)edge);
        }
        this.mapOneToMany(oneToMany);
    }

    private void mapRelationship(List<Edge> oneToMany, Edge edge, Object source, Object target) {
        boolean oneToOne = this.tryMappingAsSingleton(source, target, edge, "OUTGOING");
        if (!(oneToOne &= this.tryMappingAsSingleton(target, source, edge, "INCOMING"))) {
            oneToMany.add(edge);
        } else {
            RelationalWriter writer = this.entityAccessStrategy.getRelationalWriter(this.metadata.classInfo(source), edge.getType(), "OUTGOING", target);
            this.mappingContext.registerRelationship(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), ClassUtils.getType(writer.typeParameterDescriptor())));
        }
    }

    private void mapRelationshipEntity(List<Edge> oneToMany, Edge edge, Object source, Object target, ClassInfo relationshipEntityClassInfo) {
        ClassInfo sourceInfo;
        RelationalWriter writer;
        this.logger.debug("Found relationship type: {} to map to RelationshipEntity: {}", (Object)edge.getType(), (Object)relationshipEntityClassInfo.name());
        Object relationshipEntity = this.mappingContext.getRelationshipEntity(edge.getId());
        if (relationshipEntity == null) {
            relationshipEntity = this.createRelationshipEntity(edge, source, target);
        }
        if ((writer = this.entityAccessStrategy.getRelationalWriter(sourceInfo = this.metadata.classInfo(source), edge.getType(), "OUTGOING", relationshipEntity)) == null) {
            this.logger.debug("No writer for {}", target);
        } else if (writer.forScalar()) {
            writer.write(source, relationshipEntity);
            this.mappingContext.registerRelationship(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), ClassUtils.getType(writer.typeParameterDescriptor())));
        } else {
            oneToMany.add(edge);
        }
        ClassInfo targetInfo = this.metadata.classInfo(target);
        writer = this.entityAccessStrategy.getRelationalWriter(targetInfo, edge.getType(), "INCOMING", relationshipEntity);
        if (writer == null) {
            this.logger.debug("No writer for {}", target);
        } else if (writer.forScalar()) {
            writer.write(target, relationshipEntity);
        } else {
            oneToMany.add(edge);
        }
    }

    private Object createRelationshipEntity(Edge edge, Object startEntity, Object endEntity) {
        Object relationshipEntity = this.entityFactory.newObject(this.getRelationshipEntity(edge));
        this.setIdentity(relationshipEntity, edge.getId());
        this.setProperties(edge, relationshipEntity);
        this.mappingContext.remember(relationshipEntity);
        this.mappingContext.registerRelationshipEntity(relationshipEntity, edge.getId());
        ClassInfo relEntityInfo = this.metadata.classInfo(relationshipEntity);
        RelationalWriter startNodeWriter = this.entityAccessStrategy.getRelationalEntityWriter(relEntityInfo, StartNode.class);
        if (startNodeWriter == null) {
            throw new RuntimeException("Cannot find a writer for the StartNode of relational entity " + relEntityInfo.name());
        }
        startNodeWriter.write(relationshipEntity, startEntity);
        RelationalWriter endNodeWriter = this.entityAccessStrategy.getRelationalEntityWriter(relEntityInfo, EndNode.class);
        if (endNodeWriter == null) {
            throw new RuntimeException("Cannot find a writer for the EndNode of relational entity " + relEntityInfo.name());
        }
        endNodeWriter.write(relationshipEntity, endEntity);
        return relationshipEntity;
    }

    private void mapOneToMany(Collection<Edge> oneToManyRelationships) {
        EntityCollector entityCollector = new EntityCollector();
        ArrayList<MappedRelationship> relationshipsToRegister = new ArrayList<MappedRelationship>();
        HashSet<Edge> registeredEdges = new HashSet<Edge>();
        for (Edge edge : oneToManyRelationships) {
            RelationalWriter incomingWriter;
            RelationalWriter outgoingWriter;
            Object instance = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object parameter = this.mappingContext.getNodeEntity(edge.getEndNode());
            Object relationshipEntity = this.mappingContext.getRelationshipEntity(edge.getId());
            if (relationshipEntity != null) {
                outgoingWriter = this.findIterableWriter(instance, relationshipEntity, edge.getType(), "OUTGOING");
                if (outgoingWriter != null) {
                    entityCollector.recordTypeRelationship(edge.getStartNode(), relationshipEntity, edge.getType(), "OUTGOING");
                    relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(outgoingWriter.typeParameterDescriptor())));
                }
                if ((incomingWriter = this.findIterableWriter(parameter, relationshipEntity, edge.getType(), "INCOMING")) != null) {
                    entityCollector.recordTypeRelationship(edge.getEndNode(), relationshipEntity, edge.getType(), "INCOMING");
                    relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(incomingWriter.typeParameterDescriptor())));
                }
                if (incomingWriter == null && outgoingWriter == null) continue;
                registeredEdges.add(edge);
                continue;
            }
            outgoingWriter = this.findIterableWriter(instance, parameter, edge.getType(), "OUTGOING");
            if (outgoingWriter != null) {
                entityCollector.recordTypeRelationship(edge.getStartNode(), parameter, edge.getType(), "OUTGOING");
                relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(outgoingWriter.typeParameterDescriptor())));
            }
            if ((incomingWriter = this.findIterableWriter(parameter, instance, edge.getType(), "INCOMING")) != null) {
                entityCollector.recordTypeRelationship(edge.getEndNode(), instance, edge.getType(), "INCOMING");
                relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(incomingWriter.typeParameterDescriptor())));
            }
            if (incomingWriter == null && outgoingWriter == null) continue;
            registeredEdges.add(edge);
        }
        for (Long instanceId : entityCollector.getOwningTypes()) {
            for (String relationshipType : entityCollector.getOwningRelationshipTypes(instanceId)) {
                for (String relationshipDirection : entityCollector.getRelationshipDirectionsForOwningTypeAndRelationshipType(instanceId, relationshipType)) {
                    Set<Object> entities = entityCollector.getCollectiblesForOwnerAndRelationship(instanceId, relationshipType, relationshipDirection);
                    Class entityType = entityCollector.getCollectibleTypeForOwnerAndRelationship(instanceId, relationshipType, relationshipDirection);
                    this.mapOneToMany(this.mappingContext.getNodeEntity(instanceId), entityType, entities, relationshipType, relationshipDirection);
                }
            }
        }
        for (MappedRelationship mappedRelationship : relationshipsToRegister) {
            this.mappingContext.registerRelationship(mappedRelationship);
        }
        for (Edge edge : oneToManyRelationships) {
            MappedRelationship mappedRelationship;
            if (registeredEdges.contains(edge)) continue;
            Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
            RelationalWriter writer = this.entityAccessStrategy.getRelationalWriter(this.metadata.classInfo(source), edge.getType(), "OUTGOING", target);
            if (writer == null || this.mappingContext.isRegisteredRelationship(mappedRelationship = new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), ClassUtils.getType(writer.typeParameterDescriptor())))) continue;
            this.mappingContext.registerRelationship(mappedRelationship);
        }
    }

    private RelationalWriter findIterableWriter(Object instance, Object parameter, String relationshipType, String relationshipDirection) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        return this.entityAccessStrategy.getIterableWriter(classInfo, parameter.getClass(), relationshipType, relationshipDirection);
    }

    private void mapOneToMany(Object instance, Class<?> valueType, Object values, String relationshipType, String relationshipDirection) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        RelationalWriter writer = this.entityAccessStrategy.getIterableWriter(classInfo, valueType, relationshipType, relationshipDirection);
        if (writer != null) {
            RelationalReader reader;
            if ((writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) && (reader = this.entityAccessStrategy.getIterableReader(classInfo, valueType, relationshipType, relationshipDirection)) != null) {
                Object currentValues = reader.read(instance);
                values = writer.type().isArray() ? EntityAccess.merge(writer.type(), (Iterable)values, (Object[])currentValues) : EntityAccess.merge(writer.type(), (Iterable)values, (Iterable)currentValues);
            }
            writer.write(instance, values);
            return;
        }
        this.logger.debug("Unable to map iterable of type: {} onto property of {}", valueType, (Object)classInfo.name());
    }

    private ClassInfo getRelationshipEntity(Edge edge) {
        for (ClassInfo classInfo : this.metadata.classInfoByLabelOrType(edge.getType())) {
            if (classInfo == null) continue;
            Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
            if (!this.nodeTypeMatches(classInfo, source, StartNode.class.getName()) || !this.nodeTypeMatches(classInfo, target, EndNode.class.getName())) continue;
            return classInfo;
        }
        return null;
    }

    private boolean nodeTypeMatches(ClassInfo classInfo, Object node, String annotation) {
        FieldInfo field;
        List<FieldInfo> fields = classInfo.findFields(annotation);
        return fields.size() == 1 && (field = fields.get(0)).isTypeOf(node.getClass());
    }
}

