/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.neo4j.ogm.ClassUtils;
import org.neo4j.ogm.EntityUtils;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.annotations.DefaultEntityAccessStrategy;
import org.neo4j.ogm.annotations.EntityAccessStrategy;
import org.neo4j.ogm.annotations.FieldWriter;
import org.neo4j.ogm.annotations.PropertyReader;
import org.neo4j.ogm.annotations.RelationalReader;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.compiler.NodeBuilder;
import org.neo4j.ogm.compiler.RelationshipBuilder;
import org.neo4j.ogm.context.DirectedRelationship;
import org.neo4j.ogm.context.EntityMapper;
import org.neo4j.ogm.context.Mappable;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.TransientRelationship;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.service.Components;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityGraphMapper
implements EntityMapper {
    private final Logger logger = LoggerFactory.getLogger(EntityGraphMapper.class);
    private final MetaData metaData;
    private final EntityAccessStrategy entityAccessStrategy;
    private final MappingContext mappingContext;

    public EntityGraphMapper(MetaData metaData, MappingContext mappingContext) {
        this.metaData = metaData;
        this.mappingContext = mappingContext;
        this.entityAccessStrategy = new DefaultEntityAccessStrategy();
    }

    public CompileContext map(Object entity) {
        return this.map(entity, -1);
    }

    public CompileContext map(Object entity, int horizon) {
        if (entity == null) {
            throw new NullPointerException("Cannot map null object");
        }
        Compiler compiler = Components.compiler();
        for (MappedRelationship mappedRelationship : this.mappingContext.mappedRelationships()) {
            this.logger.debug("context-init: (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
            compiler.context().registerRelationship((Mappable)mappedRelationship);
        }
        this.logger.debug("context initialised with {} relationships", (Object)this.mappingContext.mappedRelationships().size());
        if (this.isRelationshipEntity(entity)) {
            ClassInfo reInfo = this.metaData.classInfo(entity);
            Object startNode = this.entityAccessStrategy.getStartNodeReader(reInfo).read(entity);
            if (startNode == null) {
                throw new RuntimeException("@StartNode of relationship entity may not be null");
            }
            Object endNode = this.entityAccessStrategy.getEndNodeReader(reInfo).read(entity);
            if (endNode == null) {
                throw new RuntimeException("@EndNode of relationship entity may not be null");
            }
            NodeBuilder startNodeBuilder = this.mapEntity(startNode, horizon, compiler);
            NodeBuilder endNodeBuilder = this.mapEntity(endNode, horizon, compiler);
            if (!compiler.context().visitedRelationshipEntity(EntityUtils.identity(entity, this.metaData))) {
                AnnotationInfo annotationInfo = reInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity");
                String relationshipType = annotationInfo.get("type", null);
                DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, "OUTGOING");
                RelationshipBuilder relationshipBuilder = this.getRelationshipBuilder(compiler, entity, directedRelationship, false);
                this.updateRelationshipEntity(compiler.context(), entity, relationshipBuilder, reInfo);
                ClassInfo targetInfo = this.metaData.classInfo(endNode);
                ClassInfo startInfo = this.metaData.classInfo(startNode);
                Long srcIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(startInfo).read(startNode);
                Long tgtIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(targetInfo).read(endNode);
                RelationshipNodes relNodes = new RelationshipNodes(srcIdentity, tgtIdentity, startNode.getClass(), endNode.getClass());
                this.updateRelationship(compiler.context(), startNodeBuilder, endNodeBuilder, relationshipBuilder, relNodes);
            }
        } else {
            this.mapEntity(entity, horizon, compiler);
        }
        this.deleteObsoleteRelationships(compiler);
        return compiler.context();
    }

    private void deleteObsoleteRelationships(Compiler compiler) {
        CompileContext context = compiler.context();
        Iterator<MappedRelationship> mappedRelationshipIterator = this.mappingContext.mappedRelationships().iterator();
        while (mappedRelationshipIterator.hasNext()) {
            MappedRelationship mappedRelationship = mappedRelationshipIterator.next();
            if (context.removeRegisteredRelationship((Mappable)mappedRelationship)) continue;
            this.logger.debug("context-del: (${})-[{}:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
            compiler.unrelate(Long.valueOf(mappedRelationship.getStartNodeId()), mappedRelationship.getRelationshipType(), Long.valueOf(mappedRelationship.getEndNodeId()), mappedRelationship.getRelationshipId());
            this.clearRelatedObjects(mappedRelationship.getStartNodeId());
            mappedRelationshipIterator.remove();
        }
    }

    private void clearRelatedObjects(Long node) {
        for (MappedRelationship mappedRelationship : this.mappingContext.mappedRelationships()) {
            if (mappedRelationship.getStartNodeId() != node.longValue() && mappedRelationship.getEndNodeId() != node.longValue()) continue;
            Object dirty = this.mappingContext.getNodeEntity(mappedRelationship.getEndNodeId());
            if (dirty != null) {
                this.logger.debug("flushing end node of: (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
                this.mappingContext.deregister(dirty, mappedRelationship.getEndNodeId());
            }
            if ((dirty = this.mappingContext.getNodeEntity(mappedRelationship.getStartNodeId())) == null) continue;
            this.logger.debug("flushing start node of: (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
            this.mappingContext.deregister(dirty, mappedRelationship.getStartNodeId());
        }
    }

    private NodeBuilder mapEntity(Object entity, int horizon, Compiler compiler) {
        CompileContext context = compiler.context();
        if (this.metaData.classInfo(entity) == null) {
            return null;
        }
        Long identity = EntityUtils.identity(entity, this.metaData);
        if (context.visited(identity)) {
            this.logger.debug("already visited: {}", entity);
            return context.visitedNode(identity);
        }
        NodeBuilder nodeBuilder = this.getNodeBuilder(compiler, entity);
        if (nodeBuilder != null) {
            this.updateNode(entity, context, nodeBuilder);
            if (horizon != 0) {
                this.mapEntityReferences(entity, nodeBuilder, horizon - 1, compiler);
            } else {
                this.logger.debug("at horizon: {} ", entity);
            }
        }
        return nodeBuilder;
    }

    private void updateNode(Object entity, CompileContext context, NodeBuilder nodeBuilder) {
        if (this.mappingContext.isDirty(entity)) {
            this.logger.debug("{} has changed", entity);
            context.register(entity);
            ClassInfo classInfo = this.metaData.classInfo(entity);
            for (PropertyReader propertyReader : this.entityAccessStrategy.getPropertyReaders(classInfo)) {
                Object value = propertyReader.read(entity);
                if (value == null) continue;
                nodeBuilder.addProperty(propertyReader.propertyName(), value);
            }
        } else {
            context.deregister(nodeBuilder);
            this.logger.debug("{}, has not changed", entity);
        }
    }

    private NodeBuilder getNodeBuilder(Compiler compiler, Object entity) {
        NodeBuilder nodeBuilder;
        ClassInfo classInfo = this.metaData.classInfo(entity);
        if (classInfo == null) {
            return null;
        }
        CompileContext context = compiler.context();
        Object id = this.entityAccessStrategy.getIdentityPropertyReader(classInfo).read(entity);
        if (id == null) {
            Long entityIdRef = EntityUtils.identity(entity, this.metaData);
            nodeBuilder = compiler.newNode(entityIdRef).setLabels(classInfo.labels());
            context.registerNewObject(entityIdRef, entity);
        } else {
            nodeBuilder = compiler.existingNode(Long.valueOf(id.toString())).setLabels(classInfo.labels());
        }
        Long identity = EntityUtils.identity(entity, this.metaData);
        context.visit(identity, nodeBuilder);
        this.logger.debug("visiting: {}", entity);
        return nodeBuilder;
    }

    private void mapEntityReferences(Object entity, NodeBuilder nodeBuilder, int horizon, Compiler compiler) {
        this.logger.debug("mapping references declared by: {} ", entity);
        ClassInfo srcInfo = this.metaData.classInfo(entity);
        for (RelationalReader reader : this.entityAccessStrategy.getRelationalReaders(srcInfo)) {
            ClassInfo relatedObjectClassInfo;
            ClassInfo declaredObjectInfo;
            boolean cleared;
            String relationshipType = reader.relationshipType();
            String relationshipDirection = reader.relationshipDirection();
            Class startNodeType = srcInfo.getUnderlyingClass();
            Class<?> endNodeType = ClassUtils.getType(reader.typeParameterDescriptor());
            DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
            CompileContext context = compiler.context();
            Long srcIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(srcInfo).read(entity);
            if (srcIdentity != null && !(cleared = this.clearContextRelationships(context, srcIdentity, endNodeType, directedRelationship))) {
                this.logger.debug("this relationship is already being managed: {}-{}-{}-()", new Object[]{entity, relationshipType, relationshipDirection});
                continue;
            }
            Object relatedObject = reader.read(entity);
            if (relatedObject == null) continue;
            if (this.isRelationshipEntity(relatedObject) && (declaredObjectInfo = this.metaData.classInfo(relationshipType)).isAbstract() && !(relatedObjectClassInfo = this.metaData.classInfo(relatedObject)).neo4jName().equals(directedRelationship.type())) {
                directedRelationship = new DirectedRelationship(relatedObjectClassInfo.neo4jName(), directedRelationship.direction());
                relationshipType = directedRelationship.type();
            }
            this.logger.debug("mapping reference type: {}", (Object)relationshipType);
            RelationshipNodes relNodes = new RelationshipNodes(entity, relatedObject, startNodeType, endNodeType);
            relNodes.sourceId = srcIdentity;
            Boolean mapBothWays = null;
            if (relatedObject instanceof Iterable) {
                for (Object tgtObject : (Iterable)relatedObject) {
                    if (mapBothWays == null) {
                        mapBothWays = this.bothWayMappingRequired(entity, relationshipType, tgtObject, relationshipDirection);
                    }
                    relNodes.target = tgtObject;
                    this.link(compiler, directedRelationship, nodeBuilder, horizon, mapBothWays, relNodes);
                }
                continue;
            }
            if (relatedObject.getClass().isArray()) {
                for (Object tgtObject : (Object[])relatedObject) {
                    if (mapBothWays == null) {
                        mapBothWays = this.bothWayMappingRequired(entity, relationshipType, tgtObject, relationshipDirection);
                    }
                    relNodes.target = tgtObject;
                    this.link(compiler, directedRelationship, nodeBuilder, horizon, mapBothWays, relNodes);
                }
                continue;
            }
            mapBothWays = this.bothWayMappingRequired(entity, relationshipType, relatedObject, relationshipDirection);
            this.link(compiler, directedRelationship, nodeBuilder, horizon, mapBothWays, relNodes);
        }
    }

    private boolean clearContextRelationships(CompileContext context, Long identity, Class endNodeType, DirectedRelationship directedRelationship) {
        if (directedRelationship.direction().equals("INCOMING")) {
            this.logger.debug("context-del: ({})<-[:{}]-()", (Object)identity, (Object)directedRelationship.type());
            return context.deregisterIncomingRelationships(identity, directedRelationship.type(), endNodeType, this.metaData.isRelationshipEntity(endNodeType.getName()));
        }
        if (directedRelationship.direction().equals("OUTGOING")) {
            this.logger.debug("context-del: ({})-[:{}]->()", (Object)identity, (Object)directedRelationship.type());
            return context.deregisterOutgoingRelationships(identity, directedRelationship.type(), endNodeType);
        }
        this.logger.debug("context-del: ({})<-[:{}]-()", (Object)identity, (Object)directedRelationship.type());
        this.logger.debug("context-del: ({})-[:{}]->()", (Object)identity, (Object)directedRelationship.type());
        boolean clearedIncoming = context.deregisterIncomingRelationships(identity, directedRelationship.type(), endNodeType, this.metaData.isRelationshipEntity(endNodeType.getName()));
        boolean clearedOutgoing = context.deregisterOutgoingRelationships(identity, directedRelationship.type(), endNodeType);
        return clearedIncoming || clearedOutgoing;
    }

    private void link(Compiler cypherCompiler, DirectedRelationship directedRelationship, NodeBuilder nodeBuilder, int horizon, boolean mapBothDirections, RelationshipNodes relNodes) {
        this.logger.debug("linking to entity {} in {} direction", relNodes.target, (Object)(mapBothDirections ? "both" : "one"));
        if (relNodes.target != null) {
            CompileContext context = cypherCompiler.context();
            RelationshipBuilder relationshipBuilder = this.getRelationshipBuilder(cypherCompiler, relNodes.target, directedRelationship, mapBothDirections);
            if (this.isRelationshipEntity(relNodes.target)) {
                Long reIdentity = EntityUtils.identity(relNodes.target, this.metaData);
                if (!context.visitedRelationshipEntity(reIdentity)) {
                    this.mapRelationshipEntity(relNodes.target, relNodes.source, relationshipBuilder, context, nodeBuilder, cypherCompiler, horizon, relNodes.sourceType, relNodes.targetType);
                } else {
                    this.logger.debug("RE already visited {}: ", relNodes.target);
                }
            } else {
                this.mapRelatedEntity(cypherCompiler, nodeBuilder, relationshipBuilder, horizon, relNodes);
            }
        } else {
            this.logger.debug("cannot create relationship: ({})-[:{}]->(null)", (Object)relNodes.sourceId, (Object)directedRelationship.type());
        }
    }

    private RelationshipBuilder getRelationshipBuilder(Compiler cypherBuilder, Object entity, DirectedRelationship directedRelationship, boolean mapBothDirections) {
        RelationshipBuilder relationshipBuilder;
        if (this.isRelationshipEntity(entity)) {
            Long relId = (Long)this.entityAccessStrategy.getIdentityPropertyReader(this.metaData.classInfo(entity)).read(entity);
            boolean relationshipEndsChanged = this.haveRelationEndsChanged(entity, relId);
            if (relId == null || relationshipEndsChanged) {
                relationshipBuilder = cypherBuilder.newRelationship(directedRelationship.type());
                if (relationshipEndsChanged) {
                    Field identityField = this.metaData.classInfo(entity).getField(this.metaData.classInfo(entity).identityField());
                    FieldWriter.write(identityField, entity, null);
                }
            } else {
                relationshipBuilder = cypherBuilder.existingRelationship(relId, directedRelationship.type());
            }
        } else {
            relationshipBuilder = cypherBuilder.newRelationship(directedRelationship.type(), mapBothDirections);
        }
        relationshipBuilder.direction(directedRelationship.direction());
        if (this.isRelationshipEntity(entity)) {
            relationshipBuilder.setSingleton(false);
            relationshipBuilder.setReference(EntityUtils.identity(entity, this.metaData));
            relationshipBuilder.setRelationshipEntity(true);
        }
        return relationshipBuilder;
    }

    private boolean haveRelationEndsChanged(Object entity, Long relId) {
        Object startEntity = this.getStartEntity(this.metaData.classInfo(entity), entity);
        Object targetEntity = this.getTargetEntity(this.metaData.classInfo(entity), entity);
        if (startEntity == null || targetEntity == null) {
            throw new MappingException("Relationship entity " + entity + " cannot have a missing start or end node");
        }
        ClassInfo targetInfo = this.metaData.classInfo(targetEntity);
        ClassInfo startInfo = this.metaData.classInfo(startEntity);
        Long tgtIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(targetInfo).read(targetEntity);
        Long srcIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(startInfo).read(startEntity);
        boolean relationshipEndsChanged = false;
        for (MappedRelationship mappedRelationship : this.mappingContext.mappedRelationships()) {
            if (mappedRelationship.getRelationshipId() == null || relId == null || !mappedRelationship.getRelationshipId().equals(relId) || srcIdentity != null && tgtIdentity != null && mappedRelationship.getStartNodeId() == srcIdentity.longValue() && mappedRelationship.getEndNodeId() == tgtIdentity.longValue()) continue;
            relationshipEndsChanged = true;
            break;
        }
        return relationshipEndsChanged;
    }

    private void mapRelationshipEntity(Object relationshipEntity, Object parent, RelationshipBuilder relationshipBuilder, CompileContext context, NodeBuilder nodeBuilder, Compiler cypherCompiler, int horizon, Class startNodeType, Class endNodeType) {
        this.logger.debug("mapping relationshipEntity {}", relationshipEntity);
        ClassInfo relEntityClassInfo = this.metaData.classInfo(relationshipEntity);
        this.updateRelationshipEntity(context, relationshipEntity, relationshipBuilder, relEntityClassInfo);
        Object startEntity = this.getStartEntity(relEntityClassInfo, relationshipEntity);
        Object targetEntity = this.getTargetEntity(relEntityClassInfo, relationshipEntity);
        ClassInfo targetInfo = this.metaData.classInfo(targetEntity);
        ClassInfo startInfo = this.metaData.classInfo(startEntity);
        Long tgtIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(targetInfo).read(targetEntity);
        Long srcIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(startInfo).read(startEntity);
        RelationshipNodes relNodes = parent == targetEntity ? new RelationshipNodes(tgtIdentity, srcIdentity, startNodeType, endNodeType) : new RelationshipNodes(srcIdentity, tgtIdentity, startNodeType, endNodeType);
        if (this.mappingContext.isDirty(relationshipEntity)) {
            context.register(relationshipEntity);
            if (tgtIdentity != null && srcIdentity != null) {
                MappedRelationship mappedRelationship = this.createMappedRelationship(relationshipBuilder, relNodes);
                if (this.mappingContext.mappedRelationships().remove(mappedRelationship)) {
                    this.logger.debug("RE successfully marked for re-writing");
                } else {
                    this.logger.debug("RE is new");
                }
            }
        } else {
            this.logger.debug("RE is new or has not changed");
        }
        Long startIdentity = EntityUtils.identity(startEntity, this.metaData);
        Long targetIdentity = EntityUtils.identity(targetEntity, this.metaData);
        NodeBuilder srcNodeBuilder = context.visitedNode(startIdentity);
        NodeBuilder tgtNodeBuilder = context.visitedNode(targetIdentity);
        if (parent == targetEntity) {
            if (!context.visited(startIdentity)) {
                relNodes.source = targetEntity;
                relNodes.target = startEntity;
                this.mapRelatedEntity(cypherCompiler, nodeBuilder, relationshipBuilder, horizon, relNodes);
            } else {
                this.updateRelationship(context, tgtNodeBuilder, srcNodeBuilder, relationshipBuilder, relNodes);
            }
        } else if (!context.visited(targetIdentity)) {
            relNodes.source = startEntity;
            relNodes.target = targetEntity;
            this.mapRelatedEntity(cypherCompiler, nodeBuilder, relationshipBuilder, horizon, relNodes);
        } else {
            this.updateRelationship(context, srcNodeBuilder, tgtNodeBuilder, relationshipBuilder, relNodes);
        }
    }

    private void updateRelationshipEntity(CompileContext context, Object relationshipEntity, RelationshipBuilder relationshipBuilder, ClassInfo relEntityClassInfo) {
        Long reIdentity = EntityUtils.identity(relationshipEntity, this.metaData);
        context.visitRelationshipEntity(reIdentity);
        AnnotationInfo annotation = relEntityClassInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity");
        if (relationshipBuilder.type() == null) {
            relationshipBuilder.setType(annotation.get("type", relEntityClassInfo.name()));
        }
        if (this.entityAccessStrategy.getIdentityPropertyReader(relEntityClassInfo).read(relationshipEntity) == null) {
            context.registerNewObject(reIdentity, relationshipEntity);
        }
        for (PropertyReader propertyReader : this.entityAccessStrategy.getPropertyReaders(relEntityClassInfo)) {
            relationshipBuilder.addProperty(propertyReader.propertyName(), propertyReader.read(relationshipEntity));
        }
    }

    private Object getStartEntity(ClassInfo relEntityClassInfo, Object relationshipEntity) {
        RelationalReader actualStartNodeReader = this.entityAccessStrategy.getStartNodeReader(relEntityClassInfo);
        if (actualStartNodeReader != null) {
            return actualStartNodeReader.read(relationshipEntity);
        }
        throw new RuntimeException("@StartNode of a relationship entity may not be null");
    }

    private Object getTargetEntity(ClassInfo relEntityClassInfo, Object relationshipEntity) {
        RelationalReader actualEndNodeReader = this.entityAccessStrategy.getEndNodeReader(relEntityClassInfo);
        if (actualEndNodeReader != null) {
            return actualEndNodeReader.read(relationshipEntity);
        }
        throw new RuntimeException("@EndNode of a relationship entity may not be null");
    }

    private MappedRelationship createMappedRelationship(RelationshipBuilder relationshipBuilder, RelationshipNodes relNodes) {
        MappedRelationship mappedRelationshipOutgoing = new MappedRelationship(relNodes.sourceId, relationshipBuilder.type(), relNodes.targetId, relationshipBuilder.reference(), relNodes.sourceType, relNodes.targetType);
        MappedRelationship mappedRelationshipIncoming = new MappedRelationship(relNodes.targetId, relationshipBuilder.type(), relNodes.sourceId, relationshipBuilder.reference(), relNodes.sourceType, relNodes.targetType);
        if (!relationshipBuilder.isRelationshipEntity()) {
            mappedRelationshipIncoming.setRelationshipId(null);
            mappedRelationshipOutgoing.setRelationshipId(null);
        }
        if (relationshipBuilder.hasDirection("UNDIRECTED")) {
            if (this.mappingContext.isRegisteredRelationship(mappedRelationshipIncoming)) {
                return mappedRelationshipIncoming;
            }
            return mappedRelationshipOutgoing;
        }
        if (relationshipBuilder.hasDirection("INCOMING")) {
            return mappedRelationshipIncoming;
        }
        return mappedRelationshipOutgoing;
    }

    private void mapRelatedEntity(Compiler compiler, NodeBuilder srcNodeBuilder, RelationshipBuilder relationshipBuilder, int horizon, RelationshipNodes relNodes) {
        NodeBuilder tgtNodeBuilder = this.mapEntity(relNodes.target, horizon, compiler);
        if (tgtNodeBuilder != null) {
            this.logger.debug("trying to map relationship between {} and {}", relNodes.source, relNodes.target);
            Long tgtIdentity = (Long)this.entityAccessStrategy.getIdentityPropertyReader(this.metaData.classInfo(relNodes.target)).read(relNodes.target);
            CompileContext context = compiler.context();
            relNodes.targetId = tgtIdentity;
            this.updateRelationship(context, srcNodeBuilder, tgtNodeBuilder, relationshipBuilder, relNodes);
        }
    }

    private void updateRelationship(CompileContext context, NodeBuilder srcNodeBuilder, NodeBuilder tgtNodeBuilder, RelationshipBuilder relationshipBuilder, RelationshipNodes relNodes) {
        if (relNodes.targetId == null || relNodes.sourceId == null) {
            this.maybeCreateRelationship(context, srcNodeBuilder.reference(), relationshipBuilder, tgtNodeBuilder.reference(), relNodes.sourceType, relNodes.targetType);
        } else {
            MappedRelationship mappedRelationship = this.createMappedRelationship(relationshipBuilder, relNodes);
            if (!this.mappingContext.isRegisteredRelationship(mappedRelationship)) {
                this.maybeCreateRelationship(context, srcNodeBuilder.reference(), relationshipBuilder, tgtNodeBuilder.reference(), relNodes.sourceType, relNodes.targetType);
            } else {
                this.logger.debug("context-add: ({})-[{}:{}]->({})", new Object[]{mappedRelationship.getStartNodeId(), relationshipBuilder.reference(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
                mappedRelationship.activate();
                context.registerRelationship((Mappable)mappedRelationship);
            }
        }
    }

    private void maybeCreateRelationship(CompileContext context, Long src, RelationshipBuilder relationshipBuilder, Long tgt, Class srcClass, Class tgtClass) {
        if (this.hasTransientRelationship(context, src, relationshipBuilder, tgt)) {
            this.logger.debug("new relationship is already registered");
            if (relationshipBuilder.isBidirectional()) {
                relationshipBuilder.relate(src, tgt);
                context.register((Object)new TransientRelationship(src, relationshipBuilder.reference(), relationshipBuilder.type(), tgt, tgtClass, srcClass));
            }
            return;
        }
        if (relationshipBuilder.hasDirection("INCOMING")) {
            if (this.metaData.isRelationshipEntity(tgtClass.getName())) {
                srcClass = tgtClass;
                String start = this.entityAccessStrategy.getStartNodeReader(this.metaData.classInfo(tgtClass.getName())).typeParameterDescriptor();
                tgtClass = ClassUtils.getType(start);
            }
            this.reallyCreateRelationship(context, tgt, relationshipBuilder, src, tgtClass, srcClass);
        } else {
            this.reallyCreateRelationship(context, src, relationshipBuilder, tgt, srcClass, tgtClass);
        }
    }

    private boolean hasTransientRelationship(CompileContext ctx, Long src, RelationshipBuilder relationshipBuilder, Long tgt) {
        for (Object object : ctx.registry()) {
            if (!(object instanceof TransientRelationship) || !((TransientRelationship)object).equalsIgnoreDirection(src, relationshipBuilder, tgt)) continue;
            return true;
        }
        return false;
    }

    private void reallyCreateRelationship(CompileContext ctx, Long src, RelationshipBuilder relBuilder, Long tgt, Class srcClass, Class tgtClass) {
        relBuilder.relate(src, tgt);
        this.logger.debug("context-new: ({})-[{}:{}]->({})", new Object[]{src, relBuilder.reference(), relBuilder.type(), tgt});
        if (relBuilder.isNew()) {
            ctx.register((Object)new TransientRelationship(src, relBuilder.reference(), relBuilder.type(), tgt, srcClass, tgtClass));
            if (relBuilder.isBidirectional()) {
                // empty if block
            }
        }
    }

    private boolean isRelationshipEntity(Object potentialRelationshipEntity) {
        ClassInfo classInfo = this.metaData.classInfo(potentialRelationshipEntity);
        if (classInfo == null) {
            return false;
        }
        return null != classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity");
    }

    private boolean bothWayMappingRequired(Object srcObject, String relationshipType, Object tgtObject, String relationshipDirection) {
        boolean mapBothWays = false;
        if (tgtObject.getClass().equals(srcObject.getClass())) {
            ClassInfo tgtInfo = this.metaData.classInfo(tgtObject);
            for (RelationalReader tgtRelReader : this.entityAccessStrategy.getRelationalReaders(tgtInfo)) {
                Object target;
                String tgtRelationshipDirection = tgtRelReader.relationshipDirection();
                if (!tgtRelationshipDirection.equals("OUTGOING") && !tgtRelationshipDirection.equals("INCOMING") || !tgtRelReader.relationshipType().equals(relationshipType) || !relationshipDirection.equals(tgtRelationshipDirection) || (target = tgtRelReader.read(tgtObject)) == null) continue;
                if (target instanceof Iterable) {
                    for (Object relatedObject : (Iterable)target) {
                        if (!relatedObject.equals(srcObject)) continue;
                        mapBothWays = true;
                    }
                    continue;
                }
                if (target.getClass().isArray()) {
                    for (Object relatedObject : (Object[])target) {
                        if (!relatedObject.equals(srcObject)) continue;
                        mapBothWays = true;
                    }
                    continue;
                }
                if (!target.equals(srcObject)) continue;
                mapBothWays = true;
            }
        }
        return mapBothWays;
    }

    class RelationshipNodes {
        Long sourceId;
        Long targetId;
        Class sourceType;
        Class targetType;
        Object source;
        Object target;

        public RelationshipNodes(Long sourceId, Long targetId, Class sourceType, Class targetType) {
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public RelationshipNodes(Object source, Object target, Class sourceType, Class targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.source = source;
            this.target = target;
        }

        public String toString() {
            return "RelationshipNodes{sourceId=" + this.sourceId + ", targetId=" + this.targetId + ", sourceType=" + this.sourceType + ", targetType=" + this.targetType + ", source=" + this.source + ", target=" + this.target + '}';
        }
    }
}

