/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.TransactionManagerException;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public class DefaultTransactionManager
implements TransactionManager {
    private final Driver driver;
    private static final ThreadLocal<Transaction> TRANSACTION_THREAD_LOCAL = new ThreadLocal();

    public DefaultTransactionManager() {
        this(Components.driver());
    }

    public DefaultTransactionManager(Driver driver) {
        this.driver = driver;
        this.driver.setTransactionManager((TransactionManager)this);
        TRANSACTION_THREAD_LOCAL.remove();
    }

    public Transaction openTransaction() {
        if (TRANSACTION_THREAD_LOCAL.get() == null) {
            TRANSACTION_THREAD_LOCAL.set(this.driver.newTransaction());
        } else {
            ((AbstractTransaction)TRANSACTION_THREAD_LOCAL.get()).extend();
        }
        return TRANSACTION_THREAD_LOCAL.get();
    }

    public void rollback(Transaction transaction) {
        if (transaction != this.getCurrentTransaction()) {
            throw new TransactionManagerException("Transaction is not current for this thread");
        }
        TRANSACTION_THREAD_LOCAL.remove();
    }

    public void commit(Transaction tx) {
        if (tx != this.getCurrentTransaction()) {
            throw new TransactionManagerException("Transaction is not current for this thread");
        }
        TRANSACTION_THREAD_LOCAL.remove();
    }

    public Transaction getCurrentTransaction() {
        return TRANSACTION_THREAD_LOCAL.get();
    }

    public boolean isExtended(Transaction tx) {
        return tx == this.getCurrentTransaction() && ((AbstractTransaction)tx).extensions() == 0L;
    }

    public boolean canCommit() {
        AbstractTransaction tx = (AbstractTransaction)this.getCurrentTransaction();
        return tx.extensions() == 0L && (tx.status() == Transaction.Status.COMMIT_PENDING || tx.status() == Transaction.Status.OPEN || tx.status() == Transaction.Status.PENDING);
    }

    public boolean canRollback() {
        AbstractTransaction tx = (AbstractTransaction)this.getCurrentTransaction();
        return tx.extensions() == 0L && (tx.status() == Transaction.Status.ROLLBACK_PENDING || tx.status() == Transaction.Status.COMMIT_PENDING || tx.status() == Transaction.Status.OPEN || tx.status() == Transaction.Status.PENDING);
    }
}

