/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.RequestExecutor;

public class SaveDelegate
implements Capability.Save {
    private final Neo4jSession session;
    private final RequestExecutor requestExecutor;

    public SaveDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
        this.requestExecutor = new RequestExecutor(neo4jSession);
    }

    @Override
    public <T> void save(T object) {
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            this.saveAll(object, -1);
        } else {
            this.save(object, -1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void saveAll(T object, int depth) {
        ArrayList<Object> objects;
        if (object.getClass().isArray()) {
            void var5_7;
            int length = Array.getLength(object);
            objects = new ArrayList<Object>(length);
            boolean bl = false;
            while (var5_7 < length) {
                Object arrayElement = Array.get(object, (int)var5_7);
                objects.add(arrayElement);
                ++var5_7;
            }
        } else {
            objects = (ArrayList<Object>)object;
        }
        for (Object e : objects) {
            this.save(e, depth);
        }
    }

    @Override
    public <T> void save(T object, int depth) {
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            this.saveAll(object, depth);
        } else {
            ClassInfo classInfo = this.session.metaData().classInfo(object);
            if (classInfo != null) {
                CompileContext context = new EntityGraphMapper(this.session.metaData(), this.session.context()).map(object, depth);
                this.requestExecutor.executeSave(context);
            } else {
                this.session.warn(object.getClass().getName() + " is not an instance of a persistable class");
            }
        }
    }
}

