/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.ClassUtils;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassFileProcessor;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.InterfaceInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.scanner.ClassPathScanner;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.neo4j.ogm.typeconversion.ConversionCallbackRegistry;
import org.neo4j.ogm.typeconversion.ConvertibleTypes;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfo
implements ClassFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileProcessor.class);
    private static final String dateSignature = "java/util/Date";
    private static final String bigDecimalSignature = "java/math/BigDecimal";
    private static final String bigIntegerSignature = "java/math/BigInteger";
    private static final String byteArraySignature = "[B";
    private static final String byteArrayWrapperSignature = "[Ljava/lang/Byte";
    private static final String arraySignature = "[L";
    private static final String collectionSignature = "L";
    private final List<String> classPaths = new ArrayList<String>();
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private final Map<String, ArrayList<ClassInfo>> annotationNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Map<String, ArrayList<ClassInfo>> interfaceNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Set<Class> enumTypes = new HashSet<Class>();
    private final ConversionCallbackRegistry conversionCallbackRegistry = new ConversionCallbackRegistry();

    public DomainInfo(String ... packages) {
        long now = -System.currentTimeMillis();
        this.load(packages);
        LOGGER.info("{} classes loaded in {} milliseconds", (Object)this.classNameToClassInfo.entrySet().size(), (Object)(now + System.currentTimeMillis()));
    }

    private void buildAnnotationNameToClassInfoMap() {
        LOGGER.info("Building annotation class map");
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            for (AnnotationInfo annotation : classInfo.annotations()) {
                ArrayList<ClassInfo> classInfoList = this.annotationNameToClassInfo.get(annotation.getName());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.annotationNameToClassInfo.put(annotation.getName(), classInfoList);
                }
                classInfoList.add(classInfo);
            }
        }
    }

    private void buildInterfaceNameToClassInfoMap() {
        LOGGER.info("Building interface class map for {} classes", (Object)this.classNameToClassInfo.values().size());
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            LOGGER.debug(" - {} implements {} interfaces", (Object)classInfo.simpleName(), (Object)classInfo.interfacesInfo().list().size());
            for (InterfaceInfo iface : classInfo.interfacesInfo().list()) {
                ArrayList<ClassInfo> classInfoList = this.interfaceNameToClassInfo.get(iface.name());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.interfaceNameToClassInfo.put(iface.name(), classInfoList);
                }
                LOGGER.debug("   - {}", (Object)iface.name());
                classInfoList.add(classInfo);
            }
        }
    }

    private void registerDefaultTypeConverters() {
        LOGGER.info("Registering default type converters...");
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.isEnum() || classInfo.isInterface()) continue;
            this.registerDefaultFieldConverters(classInfo);
            this.registerDefaultMethodConverters(classInfo);
        }
    }

    public void registerConversionCallback(ConversionCallback conversionCallback) {
        this.conversionCallbackRegistry.registerConversionCallback(conversionCallback);
    }

    @Override
    public void finish() {
        LOGGER.info("Starting Post-processing phase");
        this.buildAnnotationNameToClassInfoMap();
        this.buildInterfaceNameToClassInfoMap();
        this.registerDefaultTypeConverters();
        ArrayList<ClassInfo> transientClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.name() == null || classInfo.name().equals("java.lang.Object")) continue;
            LOGGER.debug("Post-processing: {}", (Object)classInfo.name());
            if (classInfo.isTransient()) {
                LOGGER.debug(" - Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
                continue;
            }
            if (classInfo.superclassName() == null || classInfo.superclassName().equals("java.lang.Object")) {
                this.extend(classInfo, classInfo.directSubclasses());
            }
            for (InterfaceInfo interfaceInfo : classInfo.interfacesInfo().list()) {
                this.implement(classInfo, interfaceInfo);
            }
        }
        LOGGER.debug("Checking for @Transient classes....");
        Collection<ArrayList<ClassInfo>> interfaceInfos = this.interfaceNameToClassInfo.values();
        for (ArrayList<ClassInfo> classInfos : interfaceInfos) {
            for (ClassInfo classInfo : classInfos) {
                if (!classInfo.isTransient()) continue;
                LOGGER.debug("Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
            }
        }
        for (ClassInfo transientClass : transientClasses) {
            this.removeTransientClass(transientClass);
        }
        LOGGER.info("Post-processing complete");
    }

    private void removeTransientClass(ClassInfo transientClass) {
        if (transientClass != null && !transientClass.name().equals("java.lang.Object")) {
            LOGGER.debug("Removing @Transient class: {}", (Object)transientClass.name());
            this.classNameToClassInfo.remove(transientClass.name());
            for (ClassInfo transientChild : transientClass.directSubclasses()) {
                this.removeTransientClass(transientChild);
            }
            for (ClassInfo transientChild : transientClass.directImplementingClasses()) {
                this.removeTransientClass(transientChild);
            }
        }
    }

    private void extend(ClassInfo superclass, List<ClassInfo> subclasses) {
        for (ClassInfo subclass : subclasses) {
            subclass.extend(superclass);
            this.extend(subclass, subclass.directSubclasses());
        }
    }

    private void implement(ClassInfo implementingClass, InterfaceInfo interfaceInfo) {
        ClassInfo interfaceClass = this.classNameToClassInfo.get(interfaceInfo.name());
        if (interfaceClass != null) {
            if (!implementingClass.directInterfaces().contains(interfaceClass)) {
                LOGGER.debug(" - Setting {} implements {}", (Object)implementingClass.simpleName(), (Object)interfaceClass.simpleName());
                implementingClass.directInterfaces().add(interfaceClass);
            }
            if (!interfaceClass.directImplementingClasses().contains(implementingClass)) {
                interfaceClass.directImplementingClasses().add(implementingClass);
            }
            for (ClassInfo subClassInfo : implementingClass.directSubclasses()) {
                this.implement(subClassInfo, interfaceInfo);
            }
        } else {
            LOGGER.debug(" - No ClassInfo found for interface class: {}", (Object)interfaceInfo.name());
        }
    }

    @Override
    public void process(InputStream inputStream) throws IOException {
        ClassInfo classInfo = new ClassInfo(inputStream);
        String className = classInfo.name();
        String superclassName = classInfo.superclassName();
        LOGGER.debug("Processing: {} -> {}", (Object)className, (Object)superclassName);
        if (className != null) {
            ClassInfo thisClassInfo = this.classNameToClassInfo.get(className);
            if (thisClassInfo == null) {
                thisClassInfo = classInfo;
                this.classNameToClassInfo.put(className, thisClassInfo);
            }
            if (!thisClassInfo.hydrated()) {
                thisClassInfo.hydrate(classInfo);
                ClassInfo superclassInfo = this.classNameToClassInfo.get(superclassName);
                if (superclassInfo == null) {
                    this.classNameToClassInfo.put(superclassName, new ClassInfo(superclassName, thisClassInfo));
                } else {
                    superclassInfo.addSubclass(thisClassInfo);
                }
            }
            if (thisClassInfo.isEnum()) {
                LOGGER.debug("Registering enum class: {}", (Object)thisClassInfo.name());
                this.enumTypes.add(thisClassInfo.getUnderlyingClass());
            }
        }
    }

    private void load(String ... packages) {
        this.classPaths.clear();
        this.classNameToClassInfo.clear();
        this.annotationNameToClassInfo.clear();
        this.interfaceNameToClassInfo.clear();
        for (String packageName : packages) {
            String path = packageName.replace(".", "/");
            this.classPaths.add(path);
        }
        new ClassPathScanner().scan(this.classPaths, this);
    }

    public ClassInfo getClass(String fqn) {
        return this.classNameToClassInfo.get(fqn);
    }

    public ClassInfo getClassSimpleName(String fullOrPartialClassName) {
        ClassInfo classInfo = this.getClassInfo(fullOrPartialClassName, this.classNameToClassInfo);
        return classInfo;
    }

    public ClassInfo getClassInfoForInterface(String fullOrPartialClassName) {
        ClassInfo classInfo = this.getClassSimpleName(fullOrPartialClassName);
        if (classInfo != null && classInfo.isInterface()) {
            return classInfo;
        }
        return null;
    }

    private ClassInfo getClassInfo(String fullOrPartialClassName, Map<String, ClassInfo> infos) {
        ClassInfo match = null;
        for (String fqn : infos.keySet()) {
            if (!fqn.endsWith("." + fullOrPartialClassName) && !fqn.equals(fullOrPartialClassName)) continue;
            if (match == null) {
                match = infos.get(fqn);
                continue;
            }
            throw new MappingException("More than one class has simple name: " + fullOrPartialClassName);
        }
        return match;
    }

    public List<ClassInfo> getClassInfosWithAnnotation(String annotation) {
        return this.annotationNameToClassInfo.get(annotation);
    }

    private void registerDefaultMethodConverters(ClassInfo classInfo) {
        for (MethodInfo methodInfo : classInfo.methodsInfo().methods()) {
            if (methodInfo.hasConverter()) continue;
            if (methodInfo.getDescriptor().contains(dateSignature) || methodInfo.getTypeParameterDescriptor() != null && methodInfo.getTypeParameterDescriptor().contains(dateSignature)) {
                this.setDateMethodConverter(methodInfo);
                continue;
            }
            if (methodInfo.getDescriptor().contains(bigIntegerSignature) || methodInfo.getTypeParameterDescriptor() != null && methodInfo.getTypeParameterDescriptor().contains(bigIntegerSignature)) {
                this.setBigIntegerMethodConverter(methodInfo);
                continue;
            }
            if (methodInfo.getDescriptor().contains(bigDecimalSignature) || methodInfo.getTypeParameterDescriptor() != null && methodInfo.getTypeParameterDescriptor().contains(bigDecimalSignature)) {
                this.setBigDecimalMethodConverter(methodInfo);
                continue;
            }
            if (methodInfo.getDescriptor().contains(byteArraySignature)) {
                methodInfo.setConverter(ConvertibleTypes.getByteArrayBase64Converter());
                continue;
            }
            if (methodInfo.getDescriptor().contains(byteArrayWrapperSignature)) {
                methodInfo.setConverter(ConvertibleTypes.getByteArrayWrapperBase64Converter());
                continue;
            }
            if (methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert") != null) {
                Class<?> entityAttributeType = ClassUtils.getType(methodInfo.getDescriptor());
                String graphTypeDescriptor = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert").get("graphPropertyType", null);
                if (graphTypeDescriptor == null) {
                    throw new MappingException("Found annotation to convert a " + entityAttributeType.getName() + " on " + classInfo.name() + '.' + methodInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                }
                methodInfo.setConverter(new ProxyAttributeConverter(entityAttributeType, ClassUtils.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
            }
            Class descriptorClass = this.getDescriptorClass(methodInfo.getDescriptor());
            Class typeParamDescriptorClass = this.getDescriptorClass(methodInfo.getTypeParameterDescriptor());
            for (Class enumClass : this.enumTypes) {
                if ((descriptorClass == null || !descriptorClass.equals(enumClass)) && (typeParamDescriptorClass == null || !typeParamDescriptorClass.equals(enumClass))) continue;
                this.setEnumMethodConverter(methodInfo, enumClass);
            }
        }
    }

    private void setEnumMethodConverter(MethodInfo methodInfo, Class enumClass) {
        if (methodInfo.getDescriptor().contains(arraySignature)) {
            methodInfo.setConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (methodInfo.getDescriptor().contains(collectionSignature) && methodInfo.isCollection()) {
            methodInfo.setConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }

    private void setBigDecimalMethodConverter(MethodInfo methodInfo) {
        if (methodInfo.getDescriptor().contains(arraySignature)) {
            methodInfo.setConverter(ConvertibleTypes.getBigDecimalArrayConverter());
        } else if (methodInfo.getDescriptor().contains(collectionSignature) && methodInfo.isCollection()) {
            methodInfo.setConverter(ConvertibleTypes.getBigDecimalCollectionConverter(methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setConverter(ConvertibleTypes.getBigDecimalConverter());
        }
    }

    private void setBigIntegerMethodConverter(MethodInfo methodInfo) {
        if (methodInfo.getDescriptor().contains(arraySignature)) {
            methodInfo.setConverter(ConvertibleTypes.getBigIntegerArrayConverter());
        } else if (methodInfo.getDescriptor().contains(collectionSignature) && methodInfo.isCollection()) {
            methodInfo.setConverter(ConvertibleTypes.getBigIntegerCollectionConverter(methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setConverter(ConvertibleTypes.getBigIntegerConverter());
        }
    }

    private void setDateMethodConverter(MethodInfo methodInfo) {
        if (methodInfo.getDescriptor().contains(arraySignature)) {
            methodInfo.setConverter(ConvertibleTypes.getDateArrayConverter());
        } else if (methodInfo.getDescriptor().contains(collectionSignature) && methodInfo.isCollection()) {
            methodInfo.setConverter(ConvertibleTypes.getDateCollectionConverter(methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setConverter(ConvertibleTypes.getDateConverter());
        }
    }

    private void registerDefaultFieldConverters(ClassInfo classInfo) {
        for (FieldInfo fieldInfo : classInfo.fieldsInfo().fields()) {
            if (fieldInfo.hasConverter()) continue;
            if (fieldInfo.getDescriptor().contains(dateSignature) || fieldInfo.getTypeParameterDescriptor() != null && fieldInfo.getTypeParameterDescriptor().contains(dateSignature)) {
                this.setDateFieldConverter(fieldInfo);
                continue;
            }
            if (fieldInfo.getDescriptor().contains(bigIntegerSignature) || fieldInfo.getTypeParameterDescriptor() != null && fieldInfo.getTypeParameterDescriptor().contains(bigIntegerSignature)) {
                this.setBigIntegerFieldConverter(fieldInfo);
                continue;
            }
            if (fieldInfo.getDescriptor().contains(bigDecimalSignature) || fieldInfo.getTypeParameterDescriptor() != null && fieldInfo.getTypeParameterDescriptor().contains(bigDecimalSignature)) {
                this.setBigDecimalConverter(fieldInfo);
                continue;
            }
            if (fieldInfo.getDescriptor().contains(byteArraySignature)) {
                fieldInfo.setConverter(ConvertibleTypes.getByteArrayBase64Converter());
                continue;
            }
            if (fieldInfo.getDescriptor().contains(byteArrayWrapperSignature)) {
                fieldInfo.setConverter(ConvertibleTypes.getByteArrayWrapperBase64Converter());
                continue;
            }
            if (fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert") != null) {
                Class<?> entityAttributeType = ClassUtils.getType(fieldInfo.getDescriptor());
                String graphTypeDescriptor = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert").get("graphPropertyType", null);
                if (graphTypeDescriptor == null) {
                    throw new MappingException("Found annotation to convert a " + entityAttributeType.getName() + " on " + classInfo.name() + '.' + fieldInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                }
                fieldInfo.setConverter(new ProxyAttributeConverter(entityAttributeType, ClassUtils.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
            }
            Class descriptorClass = this.getDescriptorClass(fieldInfo.getDescriptor());
            Class typeParamDescriptorClass = this.getDescriptorClass(fieldInfo.getTypeParameterDescriptor());
            for (Class enumClass : this.enumTypes) {
                if ((descriptorClass == null || !descriptorClass.equals(enumClass)) && (typeParamDescriptorClass == null || !typeParamDescriptorClass.equals(enumClass))) continue;
                this.setEnumFieldConverter(fieldInfo, enumClass);
            }
        }
    }

    private void setEnumFieldConverter(FieldInfo fieldInfo, Class enumClass) {
        if (fieldInfo.getDescriptor().contains(arraySignature)) {
            fieldInfo.setConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (fieldInfo.getDescriptor().contains(collectionSignature) && fieldInfo.isCollection()) {
            fieldInfo.setConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }

    private void setBigDecimalConverter(FieldInfo fieldInfo) {
        if (fieldInfo.getDescriptor().contains(arraySignature)) {
            fieldInfo.setConverter(ConvertibleTypes.getBigDecimalArrayConverter());
        } else if (fieldInfo.getDescriptor().contains(collectionSignature) && fieldInfo.isCollection()) {
            fieldInfo.setConverter(ConvertibleTypes.getBigDecimalCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setConverter(ConvertibleTypes.getBigDecimalConverter());
        }
    }

    private void setBigIntegerFieldConverter(FieldInfo fieldInfo) {
        if (fieldInfo.getDescriptor().contains(arraySignature)) {
            fieldInfo.setConverter(ConvertibleTypes.getBigIntegerArrayConverter());
        } else if (fieldInfo.getDescriptor().contains(collectionSignature) && fieldInfo.isCollection()) {
            fieldInfo.setConverter(ConvertibleTypes.getBigIntegerCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setConverter(ConvertibleTypes.getBigIntegerConverter());
        }
    }

    private void setDateFieldConverter(FieldInfo fieldInfo) {
        if (fieldInfo.getDescriptor().contains(arraySignature)) {
            fieldInfo.setConverter(ConvertibleTypes.getDateArrayConverter());
        } else if (fieldInfo.getDescriptor().contains(collectionSignature) && fieldInfo.isCollection()) {
            fieldInfo.setConverter(ConvertibleTypes.getDateCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setConverter(ConvertibleTypes.getDateConverter());
        }
    }

    public Map<String, ClassInfo> getClassInfoMap() {
        return this.classNameToClassInfo;
    }

    public List<ClassInfo> getClassInfos(String interfaceName) {
        return this.interfaceNameToClassInfo.get(interfaceName);
    }

    private Class getDescriptorClass(String descriptor) {
        Class<?> descriptorClass = null;
        if (descriptor != null) {
            try {
                descriptorClass = ClassUtils.getType(descriptor);
                if (descriptorClass.isArray()) {
                    descriptorClass = descriptorClass.getComponentType();
                }
            }
            catch (RuntimeException e) {
                LOGGER.debug("Could not load class for descriptor {}", (Object)descriptor);
            }
        }
        return descriptorClass;
    }
}

