/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.request.Statement;

public class CypherQuery
implements Statement {
    private String statement;
    private int withIndex;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Pagination paging;
    private SortOrder sortOrder = new SortOrder();
    private Filters filters = new Filters();

    public CypherQuery(String cypher, Map<String, ?> parameters) {
        this.statement = cypher;
        this.parameters.putAll(parameters);
        this.parseStatement();
    }

    public String getStatement() {
        String pagination;
        String stmt = this.statement.trim();
        String sorting = this.sortOrder().toString();
        String string = pagination = this.paging == null ? "" : this.page().toString();
        if (sorting.length() > 0 || pagination.length() > 0) {
            if (this.withIndex > -1) {
                String withClause;
                int nextClauseIndex = stmt.indexOf(" MATCH", this.withIndex);
                String newWithClause = withClause = stmt.substring(this.withIndex, nextClauseIndex);
                if (stmt.contains(")-[r")) {
                    sorting = sorting.replace("$", "r");
                    if (!withClause.contains(",r")) {
                        newWithClause = newWithClause + ",r";
                    }
                } else {
                    sorting = sorting.replace("$", "n");
                }
                stmt = stmt.replace(withClause, newWithClause + sorting + pagination);
            } else if (stmt.startsWith("MATCH p=(")) {
                String withClause = "WITH p";
                if (stmt.contains(")-[r")) {
                    withClause = withClause + ",r";
                    sorting = sorting.replace("$", "r");
                } else {
                    sorting = sorting.replace("$", "n");
                }
                stmt = stmt.replace("RETURN ", withClause + sorting + pagination + " RETURN ");
            } else {
                sorting = sorting.replace("$", "n");
                stmt = stmt.replace("RETURN ", "WITH n" + sorting + pagination + " RETURN ");
            }
        }
        return stmt;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String[] getResultDataContents() {
        return new String[0];
    }

    public boolean isIncludeStats() {
        return false;
    }

    public Pagination page() {
        return this.paging;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    protected void addPaging(Pagination page) {
        this.paging = page;
    }

    public void addSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void addFilters(Filters filters) {
        this.filters = filters;
    }

    private void parseStatement() {
        this.withIndex = this.statement.indexOf("WITH n");
    }
}

