/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.context.RestStatisticsModel;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Utils;

public class RestModelMapper
implements ResponseMapper<RestModel> {
    final GraphEntityMapper graphEntityMapper;
    final MetaData metaData;

    public RestModelMapper(GraphEntityMapper graphEntityMapper, MetaData metaData) {
        this.graphEntityMapper = graphEntityMapper;
        this.metaData = metaData;
    }

    public <T> Iterable<T> map(Class<T> type, Response<RestModel> response) {
        RestStatisticsModel restStatisticsModel = new RestStatisticsModel();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String[] columns = response.columns();
        HashMap<Long, String> relationshipEntityColumns = new HashMap<Long, String>();
        RestModel model = (RestModel)response.next();
        restStatisticsModel.setStatistics(model.getStats());
        while (model.getValues() != null) {
            ArrayList<RelationshipModel> relationshipModels = new ArrayList<RelationshipModel>();
            HashMap row = new HashMap();
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                Object value = model.getValues()[i];
                if (value instanceof List) {
                    List entityList = (List)value;
                    if (this.isMappable(entityList)) {
                        ArrayList<Object> rowVals = new ArrayList<Object>();
                        for (Object entityObj : entityList) {
                            Object mapped = this.map(relationshipModels, relationshipEntityColumns, column, value, entityObj);
                            if (mapped == null) continue;
                            rowVals.add(mapped);
                        }
                        row.put(column, rowVals);
                        continue;
                    }
                    Class<?> arrayClass = null;
                    for (Object element : entityList) {
                        Class<?> clazz = element.getClass();
                        if (arrayClass == null) {
                            arrayClass = clazz;
                            continue;
                        }
                        if (arrayClass == clazz) continue;
                        arrayClass = null;
                        break;
                    }
                    if (arrayClass == null) {
                        row.put(column, entityList.toArray());
                        continue;
                    }
                    Object array = Array.newInstance(arrayClass, entityList.size());
                    for (int j = 0; j < entityList.size(); ++j) {
                        Array.set(array, j, Utils.coerceTypes(arrayClass, entityList.get(j)));
                    }
                    row.put(column, array);
                    continue;
                }
                Object mapped = this.map(relationshipModels, relationshipEntityColumns, column, value, value);
                row.put(column, mapped);
            }
            DefaultGraphModel graphModel = new DefaultGraphModel();
            graphModel.setRelationships(relationshipModels.toArray(new RelationshipModel[relationshipModels.size()]));
            Map<Long, Object> relationshipEntities = this.graphEntityMapper.mapRelationships((GraphModel)graphModel);
            for (Map.Entry<Long, Object> entry : relationshipEntities.entrySet()) {
                if (row.get(relationshipEntityColumns.get(entry.getKey())) instanceof List) {
                    ((List)row.get(relationshipEntityColumns.get(entry.getKey()))).add(entry.getValue());
                    continue;
                }
                row.put(relationshipEntityColumns.get(entry.getKey()), entry.getValue());
            }
            result.add(row);
            model = (RestModel)response.next();
        }
        restStatisticsModel.setResult(result);
        return Arrays.asList(restStatisticsModel);
    }

    private boolean isMappable(List entityList) {
        for (Object entityObj : entityList) {
            if (entityObj instanceof Map) continue;
            return false;
        }
        return true;
    }

    private Object map(List<RelationshipModel> relationshipModels, Map<Long, String> relationshipEntityColumns, String column, Object value, Object entityObj) {
        if (entityObj instanceof Map) {
            Map entity = (Map)entityObj;
            return this.mapEntity(column, relationshipModels, relationshipEntityColumns, entity);
        }
        return value;
    }

    private Object mapEntity(String column, List<RelationshipModel> relationshipModels, Map<Long, String> relationshipEntityColumns, Map entity) {
        if (entity.containsKey("metadata") && ((Map)entity.get("metadata")).get("id") != null) {
            Map entityMetadata = (Map)entity.get("metadata");
            if (entityMetadata.containsKey("labels")) {
                List labelList = (List)entityMetadata.get("labels");
                String[] labels = new String[labelList.size()];
                labels = labelList.toArray(labels);
                DefaultGraphModel graphModel = new DefaultGraphModel();
                NodeModel nodeModel = new NodeModel();
                nodeModel.setId(Long.valueOf(((Number)entityMetadata.get("id")).longValue()));
                nodeModel.setProperties((Map)entity.get("data"));
                nodeModel.setLabels(labels);
                graphModel.setNodes(new NodeModel[]{nodeModel});
                List mapped = this.graphEntityMapper.map(this.metaData.resolve(labels).getUnderlyingClass(), (GraphModel)graphModel);
                return mapped.get(0);
            }
            if (entityMetadata.containsKey("type")) {
                String relationshipType = (String)entityMetadata.get("type");
                RelationshipModel relationshipModel = new RelationshipModel();
                relationshipModel.setId(Long.valueOf(((Number)entityMetadata.get("id")).longValue()));
                relationshipModel.setProperties((Map)entity.get("data"));
                relationshipModel.setType(relationshipType);
                String startURL = (String)entity.get("start");
                String endURL = (String)entity.get("end");
                relationshipModel.setStartNode(Long.valueOf(startURL.substring(startURL.lastIndexOf("/") + 1)));
                relationshipModel.setEndNode(Long.valueOf(endURL.substring(endURL.lastIndexOf("/") + 1)));
                relationshipModels.add(relationshipModel);
                if (relationshipModel.getPropertyList().size() > 0) {
                    relationshipEntityColumns.put(relationshipModel.getId(), column);
                }
            }
        }
        return null;
    }
}

