/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.neo4j.ogm.ClassUtils;
import org.neo4j.ogm.annotations.EntityAccess;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.session.Utils;

public class FieldWriter
extends EntityAccess {
    private final FieldInfo fieldInfo;
    private final Field field;
    private final Class<?> fieldType;

    public FieldWriter(ClassInfo classInfo, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.field = classInfo.getField(fieldInfo);
        this.fieldType = this.field.getType();
    }

    public static void write(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object read(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Object instance, Object value) {
        if (this.fieldInfo.hasConverter()) {
            value = this.fieldInfo.converter().toEntityAttribute(value);
            FieldWriter.write(this.field, instance, value);
        } else {
            String descriptor = this.fieldInfo.getTypeParameterDescriptor() == null ? this.fieldInfo.getDescriptor() : this.fieldInfo.getTypeParameterDescriptor();
            value = Utils.coerceTypes(ClassUtils.getType(descriptor), value);
            FieldWriter.write(this.field, instance, value);
        }
    }

    @Override
    public Class<?> type() {
        if (this.fieldInfo.hasConverter()) {
            try {
                for (Method method : this.fieldInfo.converter().getClass().getDeclaredMethods()) {
                    if (!method.getName().equals("toGraphProperty") || method.isSynthetic()) continue;
                    return method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.fieldType;
    }

    @Override
    public String relationshipName() {
        return this.fieldInfo.relationship();
    }

    @Override
    public String relationshipDirection() {
        return this.fieldInfo.relationshipDirection("UNDIRECTED");
    }

    @Override
    public boolean forScalar() {
        if (Iterable.class.isAssignableFrom(this.type())) {
            return false;
        }
        return !this.type().isArray();
    }

    @Override
    public String typeParameterDescriptor() {
        return this.fieldInfo.getTypeDescriptor();
    }
}

