/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.annotations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.neo4j.ogm.annotations.PropertyWriter;
import org.neo4j.ogm.annotations.RelationalWriter;
import org.neo4j.ogm.session.Utils;

public abstract class EntityAccess
implements PropertyWriter,
RelationalWriter {
    public static Object merge(Class<?> parameterType, Iterable<?> newValues, Object[] currentValues) {
        if (currentValues != null) {
            return EntityAccess.merge(parameterType, newValues, Arrays.asList(currentValues));
        }
        return EntityAccess.merge(parameterType, newValues, new ArrayList());
    }

    public static Object merge(Class<?> parameterType, Iterable<?> newValues, Iterable<?> currentValues) {
        if (parameterType.isArray()) {
            Class<?> type = parameterType.getComponentType();
            ArrayList<Object> objects = new ArrayList<Object>(EntityAccess.union(newValues, currentValues));
            Object array = Array.newInstance(type, objects.size());
            for (int i = 0; i < objects.size(); ++i) {
                Array.set(array, i, Utils.coerceTypes(type, objects.get(i)));
            }
            return array;
        }
        Collection<?> newCollection = EntityAccess.createCollection(parameterType, newValues, currentValues);
        if (newCollection != null) {
            return newCollection;
        }
        if (parameterType.isAssignableFrom(newValues.getClass())) {
            return newValues;
        }
        throw new RuntimeException("Unsupported: " + parameterType.getName());
    }

    private static Collection<?> createCollection(Class<?> parameterType, Iterable<?> collection, Iterable<?> hydrated) {
        if (Vector.class.isAssignableFrom(parameterType)) {
            return new Vector<Object>(EntityAccess.union(collection, hydrated));
        }
        if (List.class.isAssignableFrom(parameterType)) {
            return new ArrayList<Object>(EntityAccess.union(collection, hydrated));
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return new HashSet<Object>(EntityAccess.union(collection, hydrated));
        }
        return null;
    }

    private static Collection<Object> union(Iterable<?> collection, Iterable<?> hydrated) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : collection) {
            result.add(object);
        }
        if (hydrated != null) {
            for (Object object : hydrated) {
                if (result.contains(object)) continue;
                result.add(object);
            }
        }
        return result;
    }
}

