/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import org.neo4j.driver.Driver;
import org.neo4j.ogm.Neo4jOgmVersion;

public enum UserAgent {
    INSTANCE(UserAgent.getVersionOf(Driver.class), Neo4jOgmVersion.resolve());

    private final String driverVersion;
    private final String neo4jOgmVersion;
    private final String representation;

    private UserAgent(String driverVersion, String neo4jOgmVersion) {
        int idxOfDash;
        int n2 = idxOfDash = driverVersion == null ? -1 : driverVersion.indexOf(45);
        this.driverVersion = driverVersion == null ? null : driverVersion.substring(0, idxOfDash > 0 ? idxOfDash : driverVersion.length());
        this.neo4jOgmVersion = neo4jOgmVersion;
        String unknown = "-";
        this.representation = String.format("Java/%s (%s %s %s) neo4j-java/%s neo4j-ogm/%s", System.getProperty("java.version"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), this.driverVersion == null ? unknown : this.driverVersion, this.neo4jOgmVersion == null ? unknown : this.neo4jOgmVersion);
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getNeo4jOgmVersion() {
        return this.neo4jOgmVersion;
    }

    private static String getVersionOf(Class<?> type) {
        Package p = type.getPackage();
        String version = p.getImplementationVersion();
        if (version != null && !version.trim().isEmpty()) {
            return version;
        }
        return null;
    }

    public String toString() {
        return this.representation;
    }
}

