/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.types.adapter;

import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Point;
import org.neo4j.ogm.types.spatial.AbstractPoint;
import org.neo4j.ogm.types.spatial.CartesianPoint2d;
import org.neo4j.ogm.types.spatial.CartesianPoint3d;
import org.neo4j.ogm.types.spatial.GeographicPoint2d;
import org.neo4j.ogm.types.spatial.GeographicPoint3d;

public class PointToBoltValueAdapter
implements Function<AbstractPoint, Point> {
    @Override
    public Point apply(AbstractPoint object) {
        Value value;
        if (object instanceof CartesianPoint2d) {
            CartesianPoint2d point = (CartesianPoint2d)object;
            value = Values.point((int)point.getSrid(), (double)point.getX(), (double)point.getY());
        } else if (object instanceof CartesianPoint3d) {
            CartesianPoint3d point = (CartesianPoint3d)object;
            value = Values.point((int)point.getSrid(), (double)point.getX(), (double)point.getY(), (double)point.getZ());
        } else if (object instanceof GeographicPoint2d) {
            GeographicPoint2d point = (GeographicPoint2d)object;
            value = Values.point((int)point.getSrid(), (double)point.getLongitude(), (double)point.getLatitude());
        } else if (object instanceof GeographicPoint3d) {
            GeographicPoint3d point = (GeographicPoint3d)object;
            value = Values.point((int)point.getSrid(), (double)point.getLongitude(), (double)point.getLatitude(), (double)point.getHeight());
        } else {
            throw new IllegalArgumentException("Unsupported point implementation: " + String.valueOf(object.getClass()));
        }
        return value.asPoint();
    }
}

