/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoltResponse<T>
implements Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltResponse.class);
    private static final Logger cypherPerformanceNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.performance");
    private static final Logger cypherHintNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.hint");
    private static final Logger cypherUnrecognizedNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.unrecognized");
    private static final Logger cypherUnsupportedNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.unsupported");
    private static final Logger cypherDeprecationNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.deprecation");
    private static final Logger cypherGenericNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.generic");
    private static final Logger cypherSecurityNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.security");
    private static final Logger cypherTopologyNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.topology");
    private static final Pattern DEPRECATED_ID_PATTERN = Pattern.compile("(?im)The query used a deprecated function: `id`\\.");
    protected final Result result;
    private static final String LINE_SEPARATOR = System.lineSeparator();

    BoltResponse(Result result) {
        this.result = result;
    }

    public T next() {
        try {
            return this.fetchNext();
        }
        catch (ClientException ce) {
            LOGGER.debug("Error executing Cypher: {}, {}", (Object)ce.code(), (Object)ce.getMessage());
            throw new CypherException(ce.code(), ce.getMessage(), (Throwable)ce);
        }
    }

    protected abstract T fetchNext();

    public void close() {
        ResultSummary summary = this.result.consume();
        BoltResponse.process(summary);
    }

    public String[] columns() {
        Record record;
        if (this.result.hasNext() && (record = this.result.peek()) != null) {
            Set columns = this.result.peek().asMap().keySet();
            return columns.toArray(new String[columns.size()]);
        }
        return new String[0];
    }

    static ResultSummary process(ResultSummary resultSummary) {
        BoltResponse.logNotifications(resultSummary);
        return resultSummary;
    }

    private static void logNotifications(ResultSummary resultSummary) {
        Predicate<Notification> isDeprecationWarningForId;
        if (resultSummary.notifications().isEmpty() || !LOGGER.isWarnEnabled()) {
            return;
        }
        boolean supressIdDeprecations = Response.SUPPRESS_ID_DEPRECATIONS.getAcquire();
        try {
            isDeprecationWarningForId = notification -> supressIdDeprecations && notification.classification().orElse(NotificationClassification.UNRECOGNIZED) == NotificationClassification.DEPRECATION && DEPRECATED_ID_PATTERN.matcher(notification.description()).matches();
        }
        finally {
            Response.SUPPRESS_ID_DEPRECATIONS.setRelease(supressIdDeprecations);
        }
        String query = resultSummary.query().text();
        resultSummary.notifications().stream().filter(Predicate.not(isDeprecationWarningForId)).forEach(notification -> notification.severityLevel().ifPresent(severityLevel -> {
            NotificationClassification category = notification.classification().orElse(null);
            Logger logger = BoltResponse.getLogger(category);
            Consumer<String> log = severityLevel == NotificationSeverity.WARNING ? arg_0 -> ((Logger)logger).warn(arg_0) : (severityLevel == NotificationSeverity.INFORMATION ? arg_0 -> ((Logger)logger).info(arg_0) : (severityLevel == NotificationSeverity.OFF ? message -> {} : arg_0 -> ((Logger)logger).debug(arg_0)));
            log.accept(BoltResponse.format(notification, query));
        }));
    }

    private static Logger getLogger(NotificationClassification category) {
        if (category == null) {
            return LOGGER;
        }
        return switch (category) {
            case NotificationClassification.HINT -> cypherHintNotificationLog;
            case NotificationClassification.DEPRECATION -> cypherDeprecationNotificationLog;
            case NotificationClassification.PERFORMANCE -> cypherPerformanceNotificationLog;
            case NotificationClassification.GENERIC -> cypherGenericNotificationLog;
            case NotificationClassification.UNSUPPORTED -> cypherUnsupportedNotificationLog;
            case NotificationClassification.UNRECOGNIZED -> cypherUnrecognizedNotificationLog;
            case NotificationClassification.SECURITY -> cypherSecurityNotificationLog;
            case NotificationClassification.TOPOLOGY -> cypherTopologyNotificationLog;
            default -> LOGGER;
        };
    }

    private static String format(Notification notification, String forQuery) {
        InputPosition position = notification.position();
        int lineNumber = position != null ? position.line() : 1;
        int column = position != null ? position.column() : 1;
        StringBuilder queryHint = new StringBuilder();
        String[] lines = forQuery.split("(\r\n|\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            queryHint.append("\t").append(line).append(LINE_SEPARATOR);
            if (i + 1 != lineNumber) continue;
            queryHint.append("\t").append(Stream.generate(() -> " ").limit(column - 1).collect(Collectors.joining())).append("^").append(System.lineSeparator());
        }
        return String.format("%s: %s%n%s%s", notification.code(), notification.title(), queryHint, notification.description());
    }
}

