/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.ogm.drivers.bolt.response.BoltResponse;
import org.neo4j.ogm.drivers.bolt.response.BoltRestModelAdapter;
import org.neo4j.ogm.drivers.bolt.response.StatisticsModelAdapter;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.response.model.DefaultRestModel;
import org.neo4j.ogm.response.model.QueryStatisticsModel;
import org.neo4j.ogm.transaction.TransactionManager;

public class RestModelResponse
extends BoltResponse<DefaultRestModel> {
    private BoltRestModelAdapter restModelAdapter = new BoltRestModelAdapter();
    private final QueryStatisticsModel statisticsModel;
    private final Iterator<Record> resultProjection;

    public RestModelResponse(StatementResult result, TransactionManager transactionManager) {
        super(result, transactionManager);
        this.resultProjection = result.list().iterator();
        this.statisticsModel = new StatisticsModelAdapter().adapt(result);
    }

    @Override
    public DefaultRestModel fetchNext() {
        DefaultRestModel defaultRestModel = new DefaultRestModel(this.buildModel());
        defaultRestModel.setStats((QueryStatistics)this.statisticsModel);
        return defaultRestModel;
    }

    private Map<String, Object> buildModel() {
        Map<String, Object> row = new LinkedHashMap<String, Object>();
        if (this.resultProjection.hasNext()) {
            row = this.restModelAdapter.adapt(this.resultProjection.next().asMap());
        }
        return row;
    }
}

