/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.transaction;

import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltTransaction
extends AbstractTransaction {
    public static final String NEO_CLIENT_ERROR_SECURITY = "Neo.ClientError.Security";
    private final Transaction nativeTransaction;
    private final Session nativeSession;
    private final Logger LOGGER = LoggerFactory.getLogger(BoltTransaction.class);

    public BoltTransaction(TransactionManager transactionManager, Transaction transaction, Session session) {
        super(transactionManager);
        this.nativeTransaction = transaction;
        this.nativeSession = session;
    }

    public void rollback() {
        try {
            if (this.transactionManager.canRollback()) {
                this.LOGGER.debug("Rolling back native transaction: {}", (Object)this.nativeTransaction);
                this.nativeTransaction.failure();
                this.nativeTransaction.close();
                this.nativeSession.close();
            }
        }
        catch (ClientException ce) {
            throw new CypherException("Error executing Cypher", ce.neo4jErrorCode(), ce.getMessage());
        }
        catch (Exception e) {
            throw new TransactionException(e.getLocalizedMessage());
        }
        finally {
            super.rollback();
        }
    }

    public void commit() {
        try {
            if (this.transactionManager.canCommit()) {
                this.LOGGER.debug("Committing native transaction: {}", (Object)this.nativeTransaction);
                this.nativeTransaction.success();
                this.nativeTransaction.close();
                this.nativeSession.close();
            }
        }
        catch (ClientException ce) {
            this.nativeSession.close();
            if (ce.neo4jErrorCode().startsWith(NEO_CLIENT_ERROR_SECURITY)) {
                throw new ConnectionException("Security Error: " + ce.neo4jErrorCode() + ", " + ce.getMessage(), (Throwable)ce);
            }
            throw new CypherException("Error executing Cypher: " + ce.neo4jErrorCode(), ce.neo4jErrorCode(), ce.getMessage());
        }
        catch (Exception e) {
            this.nativeSession.close();
            throw new TransactionException(e.getLocalizedMessage());
        }
        finally {
            super.commit();
        }
    }

    public Transaction nativeBoltTransaction() {
        return this.nativeTransaction;
    }
}

