/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.request;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.ogm.drivers.bolt.response.GraphModelResponse;
import org.neo4j.ogm.drivers.bolt.response.GraphRowModelResponse;
import org.neo4j.ogm.drivers.bolt.response.RestModelResponse;
import org.neo4j.ogm.drivers.bolt.response.RowModelResponse;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.json.ObjectMapperFactory;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.EmptyResponse;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltRequest
implements Request {
    private final TransactionManager transactionManager;
    private static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private final Logger LOGGER = LoggerFactory.getLogger(BoltRequest.class);

    public BoltRequest(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Response<GraphModel> execute(GraphModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RowModel> execute(RowModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RowModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RowModel> execute(DefaultRequest query) {
        final ArrayList<RowModel> rowmodels = new ArrayList<RowModel>();
        String[] columns = null;
        for (Statement statement : query.getStatements()) {
            RowModel model;
            StatementResult result = this.executeRequest(statement);
            if (columns == null) {
                List columnSet = result.keys();
                columns = columnSet.toArray(new String[columnSet.size()]);
            }
            RowModelResponse rowModelResponse = new RowModelResponse(result, this.transactionManager);
            while ((model = (RowModel)rowModelResponse.next()) != null) {
                rowmodels.add(model);
            }
            result.consume();
        }
        final String[] finalColumns = columns;
        return new Response<RowModel>(){
            int currentRow = 0;

            public RowModel next() {
                if (this.currentRow < rowmodels.size()) {
                    return (RowModel)rowmodels.get(this.currentRow++);
                }
                return null;
            }

            public void close() {
            }

            public String[] columns() {
                return finalColumns;
            }
        };
    }

    public Response<GraphRowListModel> execute(GraphRowListModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphRowModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RestModel> execute(RestModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RestModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    private StatementResult executeRequest(Statement request) {
        try {
            String params = mapper.writeValueAsString((Object)request.getParameters());
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            HashMap parameterMap = (HashMap)mapper.readValue(params.getBytes(), (TypeReference)typeRef);
            this.LOGGER.info("Request: {} with params {}", (Object)request.getStatement(), (Object)parameterMap);
            if (this.transactionManager.getCurrentTransaction() == null) {
                Transaction autoCommitTx = this.transactionManager.openTransaction();
                BoltTransaction tx = (BoltTransaction)autoCommitTx;
                StatementResult statementResult = tx.nativeBoltTransaction().run(request.getStatement(), (Map)parameterMap);
                tx.commit();
                tx.close();
                return statementResult;
            }
            BoltTransaction tx = (BoltTransaction)this.transactionManager.getCurrentTransaction();
            return tx.nativeBoltTransaction().run(request.getStatement(), request.getParameters());
        }
        catch (ConnectionException | CypherException ce) {
            throw ce;
        }
        catch (ClientException ce) {
            BoltTransaction tx = (BoltTransaction)this.transactionManager.getCurrentTransaction();
            if (tx != null) {
                tx.rollback();
            }
            throw new CypherException("Error executing Cypher", ce.neo4jErrorCode(), ce.getMessage());
        }
        catch (Exception e) {
            BoltTransaction tx = (BoltTransaction)this.transactionManager.getCurrentTransaction();
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException(e);
        }
    }
}

