/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.PropertyContainer;

public interface Node
extends PropertyContainer {
    public String[] getLabels();

    public List<Property<String, Object>> getPropertyList();

    public String getPrimaryIndex();

    public String labelSignature();

    public boolean hasVersionProperty();

    @Override
    public Property<String, Long> getVersion();

    public Set<String> getPreviousDynamicLabels();

    default public Map<String, Object> toRow(String nodeIdTarget) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        rowMap.put(nodeIdTarget, this.getId());
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Property<String, Object> property : this.getPropertyList()) {
            if (property.equals(this.getVersion())) continue;
            props.put(property.getKey(), property.getValue());
        }
        rowMap.put("props", props);
        if (this.hasVersionProperty()) {
            Property<String, Long> version = this.getVersion();
            rowMap.put(version.getKey(), version.getValue());
        }
        return rowMap;
    }
}

