/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;

final class DelegatingClassLoader
extends ClassLoader {
    private final ClassLoader[] delegates;

    DelegatingClassLoader() {
        this(Collections.singletonList(DelegatingClassLoader.class.getClassLoader()));
    }

    DelegatingClassLoader(Collection<ClassLoader> delegates) {
        super(null);
        this.delegates = delegates.toArray(new ClassLoader[delegates.size()]);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Iterator<ClassLoader> classLoaders = this.getClassLoaders();
        while (classLoaders.hasNext()) {
            ClassLoader delegate = classLoaders.next();
            try {
                return delegate.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        Iterator<ClassLoader> classLoaders = this.getClassLoaders();
        while (classLoaders.hasNext()) {
            ClassLoader delegate = classLoaders.next();
            URL resource = delegate.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        Iterator<ClassLoader> classLoaders = this.getClassLoaders();
        while (classLoaders.hasNext()) {
            ClassLoader delegate = classLoaders.next();
            resources.addAll(Collections.list(delegate.getResources(name)));
        }
        return Collections.enumeration(resources);
    }

    private Iterator<ClassLoader> getClassLoaders() {
        return new Iterator<ClassLoader>(){
            private int index = 0;
            private ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
            private ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

            @Override
            public boolean hasNext() {
                return this.currentContextClassLoader != null || this.systemClassLoader != null || this.index < DelegatingClassLoader.this.delegates.length;
            }

            @Override
            public ClassLoader next() {
                ClassLoader nextClassLoader;
                if (this.currentContextClassLoader != null) {
                    nextClassLoader = this.currentContextClassLoader;
                    this.currentContextClassLoader = null;
                } else if (this.index < DelegatingClassLoader.this.delegates.length) {
                    nextClassLoader = DelegatingClassLoader.this.delegates[this.index++];
                } else if (this.systemClassLoader != null) {
                    nextClassLoader = this.systemClassLoader;
                    this.systemClassLoader = null;
                } else {
                    throw new NoSuchElementException();
                }
                return nextClassLoader;
            }
        };
    }
}

