/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.AbstractPropertyContainer;
import org.neo4j.ogm.response.model.PropertyModel;

public class NodeModel
extends AbstractPropertyContainer
implements Node {
    private final Long id;
    private Property<String, Long> version;
    private String[] labels;
    private List<Property<String, Object>> properties = new ArrayList<Property<String, Object>>();
    private String primaryIndex;
    private boolean generatedNode = false;
    private Set<String> previousDynamicLabels = Collections.emptySet();

    public NodeModel(Long id) {
        this.id = id;
    }

    public boolean isGeneratedNode() {
        return this.generatedNode;
    }

    public void setGeneratedNode(boolean generatedNode) {
        this.generatedNode = generatedNode;
    }

    @Override
    public List<Property<String, Object>> getPropertyList() {
        return this.properties;
    }

    @Override
    public String getPrimaryIndex() {
        return this.primaryIndex;
    }

    public void setPrimaryIndex(String primaryIndex) {
        this.primaryIndex = primaryIndex;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = new ArrayList<Property<String, Object>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.properties.add(new PropertyModel<String, Object>(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Property<String, Long> getVersion() {
        return this.version;
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    public void setVersion(Property<String, Long> version) {
        this.version = version;
    }

    @Override
    public boolean hasVersionProperty() {
        return this.version != null;
    }

    @Override
    public Set<String> getPreviousDynamicLabels() {
        return Collections.unmodifiableSet(this.previousDynamicLabels);
    }

    public void setPreviousDynamicLabels(Set<String> previousDynamicLabels) {
        this.previousDynamicLabels = new HashSet<String>(previousDynamicLabels);
    }

    public void setLabels(String[] labels) {
        Arrays.sort(labels);
        this.labels = labels;
    }

    public Object property(String key) {
        for (Property<String, Object> property : this.properties) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    @Override
    public String labelSignature() {
        return Stream.concat(Arrays.stream(this.labels), Optional.ofNullable(this.previousDynamicLabels).orElseGet(HashSet::new).stream()).distinct().collect(Collectors.joining(","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeModel)) {
            return false;
        }
        NodeModel nodeModel = (NodeModel)o;
        return this.id.equals(nodeModel.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

