/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class CollectionUtils {
    public static Iterable<Object> iterableOf(Object thingToIterable) {
        if (thingToIterable == null) {
            return Collections.emptyList();
        }
        if (thingToIterable instanceof Iterable) {
            return (Iterable)thingToIterable;
        }
        if (thingToIterable.getClass().isArray()) {
            return () -> new ArrayIterator(thingToIterable);
        }
        return Collections.singletonList(thingToIterable);
    }

    public static Object materializeIterableIf(Object entryValue) {
        if (entryValue instanceof Iterable && !(entryValue instanceof Collection)) {
            ArrayList hlp = new ArrayList();
            ((Iterable)entryValue).forEach(hlp::add);
            entryValue = hlp;
        }
        return entryValue;
    }

    private CollectionUtils() {
    }

    private static class ArrayIterator
    implements Iterator<Object> {
        private final Object source;
        private final int length;
        private int index = 0;

        private ArrayIterator(Object source) {
            this.source = source;
            this.length = Array.getLength(source);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public Object next() {
            return Array.get(this.source, this.index++);
        }
    }
}

