/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.driver.NativeTypesNotAvailableException;
import org.neo4j.ogm.driver.NativeTypesNotSupportedException;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.driver.TypeSystemBasedParameterConversion;
import org.neo4j.ogm.spi.CypherModificationProvider;

public abstract class AbstractConfigurableDriver
implements Driver {
    static final Set<Class<?>> DEFAULT_SUPPORTED_TYPES = Stream.of(List.class, Map.class, Boolean.class, Boolean.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, String.class).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    private final ThreadLocal<ServiceLoader<CypherModificationProvider>> cypherModificationProviderLoader = ThreadLocal.withInitial(() -> ServiceLoader.load(CypherModificationProvider.class));
    protected Configuration configuration;
    protected TypeSystem typeSystem = Driver.super.getTypeSystem();
    protected ParameterConversion parameterConversion = ParameterConversion.DefaultParameterConversion.INSTANCE;
    protected final Supplier<Map<String, Object>> customPropertiesSupplier;
    private volatile Function<String, String> cypherModification;

    public AbstractConfigurableDriver() {
        this.customPropertiesSupplier = this::getConfigurationProperties;
    }

    protected AbstractConfigurableDriver(Supplier<Map<String, Object>> customPropertiesSupplier) {
        this.customPropertiesSupplier = customPropertiesSupplier;
    }

    @Override
    public void configure(Configuration newConfiguration) {
        this.configuration = newConfiguration;
        this.initializeTypeSystem();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Function<String, String> getCypherModification() {
        Function<String, String> loadedCypherModification = this.cypherModification;
        if (loadedCypherModification == null) {
            AbstractConfigurableDriver abstractConfigurableDriver = this;
            synchronized (abstractConfigurableDriver) {
                loadedCypherModification = this.cypherModification;
                if (loadedCypherModification == null) {
                    loadedCypherModification = this.cypherModification = this.loadCypherModifications();
                }
            }
        }
        return loadedCypherModification;
    }

    private static TypeSystem loadNativeTypes(String nativeTypesImplementation) throws ClassNotFoundException {
        try {
            Class<?> nativeTypesClass = Class.forName(nativeTypesImplementation, true, Configuration.getDefaultClassLoader());
            Constructor<?> ctor = nativeTypesClass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (TypeSystem)ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not load native types implementation " + nativeTypesImplementation);
        }
    }

    private void initializeTypeSystem() {
        if (this.configuration == null || !this.configuration.getUseNativeTypes().booleanValue()) {
            this.typeSystem = TypeSystem.NoNativeTypes.INSTANCE;
            this.parameterConversion = ParameterConversion.DefaultParameterConversion.INSTANCE;
        } else {
            try {
                this.typeSystem = AbstractConfigurableDriver.loadNativeTypes(this.getTypeSystemName());
                this.parameterConversion = new TypeSystemBasedParameterConversion(this.typeSystem);
            }
            catch (UnsupportedOperationException e) {
                throw new NativeTypesNotSupportedException(this.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                throw new NativeTypesNotAvailableException(this.getClass().getName());
            }
        }
    }

    @Override
    public final TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    protected abstract String getTypeSystemName();

    private Map<String, Object> getConfigurationProperties() {
        if (this.configuration == null) {
            throw new IllegalStateException("Driver is not configured and cannot load Cypher modifications.");
        }
        return this.configuration.getCustomProperties();
    }

    private Function<String, String> loadCypherModifications() {
        Map<String, Object> configurationProperties = this.customPropertiesSupplier.get();
        ServiceLoader<CypherModificationProvider> currentProviderLoader = this.cypherModificationProviderLoader.get();
        currentProviderLoader.reload();
        return StreamSupport.stream(currentProviderLoader.spliterator(), false).sorted(Comparator.comparing(CypherModificationProvider::getOrder)).map(provider -> provider.getCypherModification(configurationProperties)).reduce(Function.identity(), Function::andThen, Function::andThen);
    }
}

