/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.driver.TypeSystem;

class TypeSystemBasedParameterConversion
implements ParameterConversion {
    private final ParameterConversion fallback = ParameterConversion.DefaultParameterConversion.INSTANCE;
    private final TypeSystem typeSystem;

    TypeSystemBasedParameterConversion(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    @Override
    public Map<String, Object> convertParameters(Map<String, Object> originalParameter) {
        return this.convertParametersImpl(originalParameter);
    }

    private Map<String, Object> convertParametersImpl(Map<String, Object> originalParameter) {
        HashMap<String, Object> convertedParameter = new HashMap<String, Object>(originalParameter.size());
        HashMap<String, Object> unconvertedParameter = new HashMap<String, Object>(originalParameter.size());
        originalParameter.forEach((parameterKey, unconvertedValue) -> {
            if (unconvertedValue == null) {
                convertedParameter.put((String)parameterKey, null);
            } else if (unconvertedValue instanceof List) {
                for (Object value : (List)unconvertedValue) {
                    if (value instanceof Map) {
                        convertedParameter.put((String)parameterKey, this.convertParametersImpl((Map)value));
                        continue;
                    }
                    if (this.typeSystem.supportsAsNativeType(unconvertedValue.getClass())) {
                        Object convertedValue = this.typeSystem.getMappedToNativeTypeAdapter(unconvertedValue.getClass()).apply(unconvertedValue);
                        convertedParameter.put((String)parameterKey, convertedValue);
                        continue;
                    }
                    unconvertedParameter.put((String)parameterKey, unconvertedValue);
                }
            } else if (unconvertedValue instanceof Map) {
                convertedParameter.put((String)parameterKey, this.convertParametersImpl((Map)unconvertedValue));
            } else if (this.typeSystem.supportsAsNativeType(unconvertedValue.getClass())) {
                Object convertedValue = this.typeSystem.getMappedToNativeTypeAdapter(unconvertedValue.getClass()).apply(unconvertedValue);
                convertedParameter.put((String)parameterKey, convertedValue);
            } else {
                unconvertedParameter.put((String)parameterKey, unconvertedValue);
            }
        });
        convertedParameter.putAll(this.fallback.convertParameters(unconvertedParameter));
        return convertedParameter;
    }
}

