/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.types.spatial;

import org.neo4j.ogm.types.spatial.AbstractPoint;
import org.neo4j.ogm.types.spatial.CartesianPoint2d;
import org.neo4j.ogm.types.spatial.CartesianPoint3d;
import org.neo4j.ogm.types.spatial.Coordinate;
import org.neo4j.ogm.types.spatial.GeographicPoint2d;
import org.neo4j.ogm.types.spatial.GeographicPoint3d;

public final class PointBuilder {
    private final int srid;
    private Coordinate coordinate;

    public static PointBuilder withSrid(int srid) {
        return new PointBuilder(srid);
    }

    private PointBuilder(int srid) {
        this.srid = srid;
    }

    public AbstractPoint build(Coordinate coordinate) {
        boolean is3d;
        boolean bl = is3d = coordinate.getZ() != null;
        if (this.srid == 7203 || this.srid == 9157) {
            return is3d ? new CartesianPoint3d(coordinate) : new CartesianPoint2d(coordinate);
        }
        return is3d ? new GeographicPoint3d(coordinate, this.srid) : new GeographicPoint2d(coordinate, (Integer)this.srid);
    }
}

