/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.driver.TypeSystemBasedParameterConversion;
import org.neo4j.ogm.spi.CypherModificationProvider;
import org.neo4j.ogm.transaction.TransactionManager;

public abstract class AbstractConfigurableDriver
implements Driver {
    private final ServiceLoader<CypherModificationProvider> cypherModificationProviderLoader = ServiceLoader.load(CypherModificationProvider.class);
    protected Configuration configuration;
    protected TypeSystem typeSystem = Driver.super.getTypeSystem();
    protected ParameterConversion parameterConversion = ParameterConversion.DefaultParameterConversion.INSTANCE;
    protected TransactionManager transactionManager;
    protected final Supplier<Map<String, Object>> customPropertiesSupplier;
    private volatile Function<String, String> cypherModification;

    public AbstractConfigurableDriver() {
        this.customPropertiesSupplier = this::getConfigurationProperties;
    }

    protected AbstractConfigurableDriver(Supplier<Map<String, Object>> customPropertiesSupplier) {
        this.customPropertiesSupplier = customPropertiesSupplier;
    }

    @Override
    public void configure(Configuration configuration) {
        this.configuration = configuration;
        this.initializeTypeSystem();
    }

    @Override
    public void setTransactionManager(TransactionManager transactionManager) {
        assert (transactionManager != null);
        this.transactionManager = transactionManager;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Function<String, String> getCypherModification() {
        Function<String, String> loadedCypherModification = this.cypherModification;
        if (loadedCypherModification == null) {
            AbstractConfigurableDriver abstractConfigurableDriver = this;
            synchronized (abstractConfigurableDriver) {
                if (this.cypherModification == null) {
                    loadedCypherModification = this.cypherModification = this.loadCypherModifications();
                }
            }
        }
        return loadedCypherModification;
    }

    private static TypeSystem loadNativeTypes(String nativeTypesImplementation) throws ClassNotFoundException {
        try {
            Class<?> nativeTypesClass = Class.forName(nativeTypesImplementation, true, AbstractConfigurableDriver.class.getClassLoader());
            Constructor<?> ctor = nativeTypesClass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (TypeSystem)ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not load native types implementation " + nativeTypesImplementation);
        }
    }

    private void initializeTypeSystem() {
        if (this.configuration == null || !this.configuration.getUseNativeTypes().booleanValue()) {
            this.typeSystem = TypeSystem.NoNativeTypes.INSTANCE;
            this.parameterConversion = ParameterConversion.DefaultParameterConversion.INSTANCE;
        } else {
            try {
                this.typeSystem = AbstractConfigurableDriver.loadNativeTypes(this.getTypeSystemName());
                this.parameterConversion = new TypeSystemBasedParameterConversion(this.typeSystem);
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalStateException("Neo4j-OGM driver " + this.getClass().getName() + " doesn't support native types.");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot use native types. Make sure you have the native module for your driver on the classpath.");
            }
        }
    }

    @Override
    public final TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    protected abstract String getTypeSystemName();

    private Map<String, Object> getConfigurationProperties() {
        if (this.configuration == null) {
            throw new IllegalStateException("Driver is not configured and cannot load Cypher modifications.");
        }
        return this.configuration.getCustomProperties();
    }

    private Function<String, String> loadCypherModifications() {
        Map<String, Object> configurationProperties = this.customPropertiesSupplier.get();
        this.cypherModificationProviderLoader.reload();
        return StreamSupport.stream(this.cypherModificationProviderLoader.spliterator(), false).sorted(Comparator.comparing(CypherModificationProvider::getOrder)).map(provider -> provider.getCypherModification(configurationProperties)).reduce(Function.identity(), Function::andThen, Function::andThen);
    }
}

