/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.PropertyModel;

public class NodeModel
implements Node {
    private Long id;
    private String[] labels;
    private String[] removedLabels;
    private List<Property<String, Object>> properties = new ArrayList<Property<String, Object>>();
    private String primaryIndex;

    @Override
    public List<Property<String, Object>> getPropertyList() {
        return this.properties;
    }

    @Override
    public String getPrimaryIndex() {
        return this.primaryIndex;
    }

    public void setPrimaryIndex(String primaryIndex) {
        this.primaryIndex = primaryIndex;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = new ArrayList<Property<String, Object>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.properties.add(new PropertyModel<String, Object>(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    @Override
    public String[] getRemovedLabels() {
        return this.removedLabels;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLabels(String[] labels) {
        Arrays.sort(labels);
        this.labels = labels;
    }

    public void removeLabels(String[] labels) {
        Arrays.sort(labels);
        this.removedLabels = labels;
    }

    public Object property(String key) {
        for (Property<String, Object> property : this.properties) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    @Override
    public String labelSignature() {
        ArrayList<String> allLabels = new ArrayList<String>();
        Collections.addAll(allLabels, this.labels);
        if (this.removedLabels != null) {
            allLabels.add("_SEPARATOR_");
            Collections.addAll(allLabels, this.removedLabels);
        }
        return allLabels.stream().collect(Collectors.joining(","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeModel nodeModel = (NodeModel)o;
        return this.id.equals(nodeModel.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

