/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import org.neo4j.ogm.driver.Driver;

public class DriverManager {
    private static Driver driver;

    public static void register(String driverClassName) {
        if (driver != null && driver.getClass().getCanonicalName().equals(driverClassName)) {
            return;
        }
        if (driver != null) {
            driver.close();
        }
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            driver = (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Driver getDriver() {
        return driver;
    }

    public static void deregister(Driver driver) {
        if (DriverManager.driver != null) {
            DriverManager.driver.close();
            DriverManager.driver = null;
        }
    }

    public static void register(Driver driver) {
        if (DriverManager.driver != null) {
            DriverManager.driver.close();
        }
        DriverManager.driver = driver;
    }
}

