/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import org.apache.commons.codec.binary.Base64;
import org.neo4j.ogm.config.Credentials;

public class UsernamePasswordCredentials
implements Credentials<String> {
    private final String credentials;
    private final String username;
    private final String password;

    public UsernamePasswordCredentials(String userName, String password) {
        if (userName == null || password == null) {
            throw new IllegalArgumentException("username or password cannot be null");
        }
        this.credentials = Base64.encodeBase64String((byte[])userName.concat(":").concat(password).getBytes());
        this.username = userName;
        this.password = password;
    }

    @Override
    public String credentials() {
        return this.credentials;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

