/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.neo4j.ogm.classloader.ClassLoaderResolver;
import org.neo4j.ogm.config.CompilerConfiguration;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.service.Components;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private final Map<String, Object> config = new HashMap<String, Object>();
    private DriverConfiguration driverConfiguration;
    private CompilerConfiguration compilerConfiguration;

    public Configuration() {
    }

    public Configuration(String propertiesFilename) {
        this.driverConfiguration = null;
        this.compilerConfiguration = null;
        this.configure(propertiesFilename);
    }

    public void set(String key, Object value) {
        this.config.put(key, value);
    }

    public Object get(String key) {
        return this.config.get(key);
    }

    public Object get(String ... keys) {
        for (String key : keys) {
            Object obj = this.config.get(key);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    private void configure(String propertiesFileName) {
        try (InputStream is = ClassLoaderResolver.resolve().getResourceAsStream(propertiesFileName);){
            Properties properties = new Properties();
            properties.load(is);
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                this.config.put(propertyName, properties.getProperty(propertyName));
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not load {}", (Object)propertiesFileName);
        }
    }

    public synchronized DriverConfiguration driverConfiguration() {
        if (this.driverConfiguration == null) {
            this.driverConfiguration = new DriverConfiguration(this);
        }
        return this.driverConfiguration;
    }

    public synchronized CompilerConfiguration compilerConfiguration() {
        if (this.compilerConfiguration == null) {
            this.compilerConfiguration = new CompilerConfiguration(this);
        }
        return this.compilerConfiguration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" {\n");
        for (Map.Entry<String, Object> entry : this.config.entrySet()) {
            sb.append("\t");
            sb.append((Object)entry.getKey());
            sb.append("='");
            sb.append(entry.getValue());
            sb.append("'");
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public void clear() {
        this.config.clear();
    }

    @Override
    public void close() {
        Components.destroy();
    }
}

