/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.service;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverService {
    private static final Logger logger = LoggerFactory.getLogger(DriverService.class);

    private static Driver load(String className) {
        Iterator<Driver> iterator = ServiceLoader.load(Driver.class).iterator();
        while (iterator.hasNext()) {
            try {
                Driver driver = iterator.next();
                if (!driver.getClass().getName().equals(className)) continue;
                logger.debug("Using driver: {}", (Object)className);
                return driver;
            }
            catch (ServiceConfigurationError sce) {
                logger.warn("{}, reason: {}", (Object)sce.getLocalizedMessage(), (Object)sce.getCause());
            }
        }
        throw new ServiceNotFoundException("Driver: " + className);
    }

    public static Driver load(DriverConfiguration configuration) {
        String driverClassName = configuration.getDriverClassName();
        Driver driver = DriverService.load(driverClassName);
        driver.configure(configuration);
        return driver;
    }
}

