/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.net.URL;
import org.neo4j.ogm.authentication.Credentials;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.config.Configuration;

public class DriverConfiguration {
    public static final String DRIVER = "driver";
    public static final String CREDENTIALS = "credentials";
    public static final String URI = "URI";
    private final Configuration configuration;

    public DriverConfiguration() {
        this.configuration = new Configuration();
    }

    public DriverConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public DriverConfiguration setDriverClassName(String driverClassName) {
        this.configuration.set(DRIVER, driverClassName);
        return this;
    }

    public DriverConfiguration setURI(String uri) {
        this.configuration.set(URI, uri);
        try {
            URL url = new URL(uri);
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                String[] userPass = userInfo.split(":");
                this.setCredentials(userPass[0], userPass[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DriverConfiguration setCredentials(Credentials credentials) {
        this.configuration.set(CREDENTIALS, credentials);
        return this;
    }

    public DriverConfiguration setCredentials(String username, String password) {
        this.configuration.set(CREDENTIALS, new UsernamePasswordCredentials(username, password));
        return this;
    }

    public Credentials getCredentials() {
        if (this.configuration.get(CREDENTIALS) == null) {
            this.setURI((String)this.configuration.get(URI));
        }
        if (this.configuration.get(CREDENTIALS) == null) {
            String username = (String)this.configuration.get("username");
            String password = (String)this.configuration.get("password");
            if (username != null && password != null) {
                this.setCredentials(username, password);
            }
        }
        return (Credentials)this.configuration.get(CREDENTIALS);
    }

    public String getURI() {
        return (String)this.configuration.get(URI);
    }

    public String getDriverClassName() {
        return (String)this.configuration.get(DRIVER);
    }
}

