/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.neo4j.ogm.classloader.ClassLoaderResolver;
import org.neo4j.ogm.config.CompilerConfiguration;
import org.neo4j.ogm.config.DriverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private final Map<String, Object> config = new HashMap<String, Object>();

    public Configuration() {
    }

    public Configuration(String propertiesFilename) {
        this.configure(propertiesFilename);
    }

    public void set(String key, Object value) {
        this.config.put(key, value);
    }

    public Object get(String key) {
        return this.config.get(key);
    }

    private void configure(String propertiesFileName) {
        try (InputStream is = ClassLoaderResolver.resolve().getResourceAsStream(propertiesFileName);){
            Properties properties = new Properties();
            properties.load(is);
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                this.config.put(propertyName, properties.getProperty(propertyName));
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not load {}", (Object)propertiesFileName);
        }
    }

    public DriverConfiguration driverConfiguration() {
        return new DriverConfiguration(this);
    }

    public CompilerConfiguration compilerConfiguration() {
        return new CompilerConfiguration(this);
    }
}

