/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.transaction;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransaction
implements Transaction {
    private final Logger logger = LoggerFactory.getLogger(Transaction.class);
    protected final TransactionManager transactionManager;
    protected final AtomicLong extendsCount = new AtomicLong();
    private Transaction.Status status = Transaction.Status.OPEN;

    public AbstractTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void rollback() {
        long extensions = this.extendsCount.get();
        if (extensions == 0L) {
            if (this.transactionManager != null) {
                this.logger.debug("Rollback invoked");
                this.transactionManager.rollback(this);
                this.status = Transaction.Status.ROLLEDBACK;
            }
        } else {
            this.logger.debug("Rollback pending");
            this.status = Transaction.Status.ROLLBACK_PENDING;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit() {
        long extensions = this.extendsCount.get();
        if (extensions == 0L) {
            if (this.status != Transaction.Status.OPEN && this.status != Transaction.Status.PENDING && this.status != Transaction.Status.COMMIT_PENDING) throw new TransactionException("Transaction cannot commit");
            if (this.transactionManager == null) return;
            this.logger.debug("Commit invoked");
            this.transactionManager.commit(this);
            this.status = Transaction.Status.COMMITTED;
            return;
        } else {
            if (this.status == Transaction.Status.ROLLBACK_PENDING) {
                throw new TransactionException("Transaction cannot commit: rollback pending");
            }
            this.logger.debug("Commit pending");
            this.status = Transaction.Status.COMMIT_PENDING;
        }
    }

    public void extend() {
        this.extendsCount.incrementAndGet();
        this.logger.debug("Transaction extended: {}", (Object)this.extendsCount.get());
    }

    @Override
    public final Transaction.Status status() {
        return this.status;
    }

    @Override
    public void close() {
        long extensions = this.extendsCount.get();
        if (extensions == 0L) {
            this.logger.debug("Closing transaction");
            if (this.status == Transaction.Status.ROLLBACK_PENDING) {
                this.rollback();
            } else if (this.status == Transaction.Status.COMMIT_PENDING) {
                this.commit();
            } else if (this.status == Transaction.Status.PENDING || this.status == Transaction.Status.OPEN) {
                this.rollback();
            }
            this.status = Transaction.Status.CLOSED;
        }
        this.extendsCount.getAndDecrement();
    }

    public long extensions() {
        return this.extendsCount.get();
    }
}

