/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;

public class DefaultGraphModel
implements GraphModel {
    private final Map<Long, NodeModel> nodeMap = new HashMap<Long, NodeModel>();
    private final Map<Long, RelationshipModel> relationshipMap = new HashMap<Long, RelationshipModel>();
    private final Set<Node> nodes = new LinkedHashSet<Node>();
    private final Set<Edge> relationships = new LinkedHashSet<Edge>();

    @Override
    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(NodeModel[] nodes) {
        for (NodeModel node : nodes) {
            this.nodes.add(node);
            this.nodeMap.put(node.getId(), node);
        }
    }

    @Override
    public Set<Edge> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(RelationshipModel[] relationships) {
        for (RelationshipModel relationship : relationships) {
            this.relationships.add(relationship);
            this.relationshipMap.put(relationship.getId(), relationship);
        }
    }

    public NodeModel node(Long nodeId) {
        return this.nodeMap.get(nodeId);
    }

    public boolean containsNodeWithId(Long nodeId) {
        return this.nodeMap.containsKey(nodeId);
    }

    public boolean containsRelationshipWithId(Long relId) {
        return this.relationshipMap.containsKey(relId);
    }
}

