/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.notifications;

import java.util.Objects;
import org.neo4j.gqlstatus.CommonGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfo;
import org.neo4j.gqlstatus.NotificationClassification;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.notifications.NotificationCodeWithDescription;

public final class NotificationImplementation
extends CommonGqlStatusObjectImplementation
implements Notification,
GqlStatusObject {
    private final Status neo4jStatus;
    private final String title;
    private final String descriptionWithParameters;
    private final InputPosition position;

    NotificationImplementation(Status neo4jStatus, GqlStatusInfo gqlStatusInfo, DiagnosticRecord diagnosticRecord, InputPosition position, String title, String descriptionWithParameters, Object[] messageParameterValues) {
        super(gqlStatusInfo, diagnosticRecord, messageParameterValues);
        this.neo4jStatus = neo4jStatus;
        this.position = position;
        this.title = title;
        this.descriptionWithParameters = descriptionWithParameters;
    }

    public Status getNeo4jStatus() {
        return this.neo4jStatus;
    }

    public String getCode() {
        return this.neo4jStatus.code().serialize();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.descriptionWithParameters;
    }

    public InputPosition getPosition() {
        return this.position;
    }

    public NotificationCategory getCategory() {
        return this.mapCategory(this.diagnosticRecord.asMap().get("_classification").toString());
    }

    public NotificationClassification getClassification() {
        return this.mapClassification(this.diagnosticRecord.asMap().get("_classification").toString());
    }

    public SeverityLevel getSeverity() {
        return this.mapSeverity(this.diagnosticRecord.asMap().get("_severity").toString());
    }

    public String toString() {
        return "Notification{position=" + this.position + ", description='" + this.descriptionWithParameters + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NotificationImplementation that = (NotificationImplementation)((Object)o);
        return Objects.equals(this.position, that.position) && Objects.equals(this.descriptionWithParameters, that.descriptionWithParameters) && Objects.equals(this.gqlStatusInfo, that.gqlStatusInfo) && Objects.equals(this.title, that.title) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.descriptionWithParameters, this.gqlStatusInfo, this.title, this.diagnosticRecord);
    }

    private SeverityLevel mapSeverity(String severityLevel) {
        return SeverityLevel.valueOf((String)severityLevel);
    }

    private NotificationCategory mapCategory(String category) {
        return NotificationCategory.valueOf((String)category);
    }

    private NotificationClassification mapClassification(String classification) {
        return NotificationClassification.valueOf((String)classification);
    }

    public static class NotificationBuilder {
        private final NotificationCodeWithDescription notificationCodeWithDescription;
        private final GqlStatusInfo gqlStatusInfo;
        private Object[] messageParameterValues = new String[0];
        private String title;
        private InputPosition position;
        private String[] notificationDetails;

        public NotificationBuilder(NotificationCodeWithDescription notificationCodeWithDescription) {
            this.notificationCodeWithDescription = notificationCodeWithDescription;
            this.gqlStatusInfo = notificationCodeWithDescription.getGqlStatusInfo();
            this.title = notificationCodeWithDescription.getStatus().code().description();
            this.position = InputPosition.empty;
        }

        public NotificationBuilder setPosition(InputPosition position) {
            this.position = position;
            return this;
        }

        public NotificationBuilder setTitleDetails(String ... details) {
            if (details.length > 0) {
                this.title = String.format(this.title, details);
            }
            return this;
        }

        public NotificationBuilder setNotificationDetails(String ... details) {
            this.notificationDetails = details;
            return this;
        }

        public NotificationBuilder setMessageParameters(Object[] messageParameterValues) {
            this.messageParameterValues = messageParameterValues;
            return this;
        }

        public NotificationImplementation build() {
            String detailedDescription = this.notificationCodeWithDescription.getDescription(this.notificationDetails);
            Status.Code statusCode = this.notificationCodeWithDescription.getStatus().code();
            if (!(statusCode instanceof Status.NotificationCode)) {
                throw new IllegalStateException("'" + statusCode + "' is not a notification code.");
            }
            Status.NotificationCode notificationCode = (Status.NotificationCode)statusCode;
            String severity = notificationCode.getSeverity();
            NotificationClassification classification = NotificationClassification.valueOf((String)notificationCode.getNotificationCategory());
            DiagnosticRecord diagnosticRecord = new DiagnosticRecord(severity, (GqlClassification)classification, this.position.getOffset(), this.position.getLine(), this.position.getColumn());
            return new NotificationImplementation(this.notificationCodeWithDescription.getStatus(), this.gqlStatusInfo, diagnosticRecord, this.position, this.title, detailedDescription, this.messageParameterValues);
        }
    }
}

