/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.monitoring;

import org.neo4j.common.ProgressReporter;
import org.neo4j.logging.Log;

public class LogProgressReporter
implements ProgressReporter {
    private static final int STRIDE = 10;
    private static final int HUNDRED = 100;
    private final Log log;
    private long current;
    private int currentPercent;
    private long max;

    public LogProgressReporter(Log log) {
        this.log = log;
    }

    public void progress(long add) {
        this.current += add;
        int percent = this.max == 0L ? 100 : Math.min(100, (int)(this.current * 100L / this.max));
        this.ensurePercentReported(percent);
    }

    private void ensurePercentReported(int percent) {
        while (this.currentPercent < percent) {
            this.reportPercent(++this.currentPercent);
        }
    }

    private void reportPercent(int percent) {
        if (percent % 10 == 0) {
            this.log.info(String.format("  %d%% completed", percent));
        }
    }

    public void start(long max) {
        this.max = max;
    }

    public void completed() {
        this.ensurePercentReported(100);
    }
}

