/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.CompositeDatabaseHealth;
import org.neo4j.monitoring.DatabasePanicEventGenerator;
import org.neo4j.monitoring.Health;

public class DatabaseHealth
extends LifecycleAdapter
implements Health {
    private static final String panicMessage = "The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.";
    private static final Class<? extends Throwable> CRITICAL_EXCEPTION = OutOfMemoryError.class;
    private volatile boolean healthy = true;
    private final DatabasePanicEventGenerator panicEventGenerator;
    private final Log log;
    private volatile Throwable causeOfPanic;
    private final CompositeDatabaseHealth globalHealth;

    public DatabaseHealth(DatabasePanicEventGenerator panicEventGenerator, Log log) {
        this(panicEventGenerator, log, null);
    }

    public DatabaseHealth(DatabasePanicEventGenerator panicEventGenerator, Log log, CompositeDatabaseHealth globalHealth) {
        this.panicEventGenerator = panicEventGenerator;
        this.log = log;
        this.globalHealth = globalHealth;
    }

    public void stop() throws Exception {
        if (this.globalHealth != null) {
            this.globalHealth.removeDatabaseHealth(this);
        }
    }

    @Override
    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        if (!this.healthy) {
            throw Exceptions.disguiseException(panicDisguise, (String)panicMessage, (Throwable)this.causeOfPanic);
        }
    }

    @Override
    public synchronized void panic(Throwable cause) {
        if (!this.healthy) {
            return;
        }
        Objects.requireNonNull(cause, "Must provide a non null cause for the database panic");
        this.causeOfPanic = cause;
        this.healthy = false;
        this.log.error("Database panic: The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.", cause);
        this.panicEventGenerator.panic();
    }

    @Override
    public boolean isHealthy() {
        return this.healthy;
    }

    @Override
    public synchronized boolean healed() {
        if (this.hasCriticalFailure()) {
            this.log.error("Database encountered a critical error and can't be healed. Restart required.");
            return false;
        }
        this.healthy = true;
        this.causeOfPanic = null;
        this.log.info("Database health set to OK");
        return true;
    }

    private boolean hasCriticalFailure() {
        return !this.isHealthy() && ExceptionUtils.indexOfThrowable((Throwable)this.causeOfPanic, CRITICAL_EXCEPTION) != -1;
    }

    @Override
    public Throwable cause() {
        return this.causeOfPanic;
    }
}

