/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DefaultDatabaseEvent;
import org.neo4j.logging.Log;

public class DatabaseEventListeners {
    private final List<DatabaseEventListener> databaseEventListeners = new CopyOnWriteArrayList<DatabaseEventListener>();
    private final Log log;

    public DatabaseEventListeners(Log log) {
        this.log = log;
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        if (this.databaseEventListeners.contains(listener)) {
            return;
        }
        this.databaseEventListeners.add(listener);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        if (!this.databaseEventListeners.remove(listener)) {
            throw new IllegalStateException("Database listener `" + listener + "` is not registered.");
        }
    }

    public void databaseStart(String databaseName) {
        DefaultDatabaseEvent eventContext = new DefaultDatabaseEvent(databaseName);
        this.notifyEventListeners(handler -> handler.databaseStart((DatabaseEventContext)eventContext));
    }

    public void databaseShutdown(String databaseName) {
        DefaultDatabaseEvent eventContext = new DefaultDatabaseEvent(databaseName);
        this.notifyEventListeners(handler -> handler.databaseShutdown((DatabaseEventContext)eventContext));
    }

    void databasePanic(String databaseName) {
        DefaultDatabaseEvent eventContext = new DefaultDatabaseEvent(databaseName);
        this.notifyEventListeners(handler -> handler.databasePanic((DatabaseEventContext)eventContext));
    }

    private void notifyEventListeners(Consumer<DatabaseEventListener> consumer) {
        for (DatabaseEventListener listener : this.databaseEventListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable e) {
                this.log.error("Error while handling database event by listener: " + listener, e);
            }
        }
    }
}

