/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.function.Consumer;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class DuplicatingLog
extends AbstractLog {
    private final CopyOnWriteArraySet<Log> logs;
    private final DuplicatingLogger debugLogger;
    private final DuplicatingLogger infoLogger;
    private final DuplicatingLogger warnLogger;
    private final DuplicatingLogger errorLogger;

    public DuplicatingLog(Log ... logs) {
        this(Arrays.asList(logs));
    }

    public DuplicatingLog(List<Log> logs) {
        ArrayList<Logger> debugLoggers = new ArrayList<Logger>(logs.size());
        ArrayList<Logger> infoLoggers = new ArrayList<Logger>(logs.size());
        ArrayList<Logger> warnLoggers = new ArrayList<Logger>(logs.size());
        ArrayList<Logger> errorLoggers = new ArrayList<Logger>(logs.size());
        for (Log log : logs) {
            debugLoggers.add(log.debugLogger());
            infoLoggers.add(log.infoLogger());
            warnLoggers.add(log.warnLogger());
            errorLoggers.add(log.errorLogger());
        }
        this.logs = new CopyOnWriteArraySet<Log>(logs);
        this.debugLogger = new DuplicatingLogger(debugLoggers);
        this.infoLogger = new DuplicatingLogger(infoLoggers);
        this.warnLogger = new DuplicatingLogger(warnLoggers);
        this.errorLogger = new DuplicatingLogger(errorLoggers);
    }

    public boolean remove(Log log) {
        boolean removed = this.logs.remove(log);
        this.debugLogger.remove(log.debugLogger());
        this.infoLogger.remove(log.infoLogger());
        this.warnLogger.remove(log.warnLogger());
        this.errorLogger.remove(log.errorLogger());
        return removed;
    }

    @Override
    public boolean isDebugEnabled() {
        for (Log log : this.logs) {
            if (!log.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Logger debugLogger() {
        return this.debugLogger;
    }

    @Override
    public Logger infoLogger() {
        return this.infoLogger;
    }

    @Override
    public Logger warnLogger() {
        return this.warnLogger;
    }

    @Override
    public Logger errorLogger() {
        return this.errorLogger;
    }

    @Override
    public void bulk(Consumer<Log> consumer) {
        DuplicatingLog.bulk(new LinkedList<Log>(this.logs), new ArrayList<Log>(this.logs.size()), consumer);
    }

    private static void bulk(final LinkedList<Log> remaining, final ArrayList<Log> bulkLogs, final Consumer<Log> finalConsumer) {
        if (!remaining.isEmpty()) {
            Log log = remaining.pop();
            log.bulk(new Consumer<Log>(){

                public void accept(Log bulkLog) {
                    bulkLogs.add(bulkLog);
                    DuplicatingLog.bulk(remaining, bulkLogs, (Consumer<Log>)finalConsumer);
                }
            });
        } else {
            DuplicatingLog log = new DuplicatingLog(bulkLogs);
            finalConsumer.accept((Object)log);
        }
    }

    private static class DuplicatingLogger
    implements Logger {
        private final CopyOnWriteArraySet<Logger> loggers;

        public DuplicatingLogger(List<Logger> loggers) {
            this.loggers = new CopyOnWriteArraySet<Logger>(loggers);
        }

        public boolean remove(Logger logger) {
            return this.loggers.remove(logger);
        }

        @Override
        public void log(String message) {
            for (Logger logger : this.loggers) {
                logger.log(message);
            }
        }

        @Override
        public void log(String message, Throwable throwable) {
            for (Logger logger : this.loggers) {
                logger.log(message, throwable);
            }
        }

        @Override
        public void log(String format, Object ... arguments) {
            for (Logger logger : this.loggers) {
                logger.log(format, arguments);
            }
        }

        @Override
        public void bulk(Consumer<Logger> consumer) {
            DuplicatingLogger.bulk(new LinkedList<Logger>(this.loggers), new ArrayList<Logger>(this.loggers.size()), consumer);
        }

        private static void bulk(final LinkedList<Logger> remaining, final ArrayList<Logger> bulkLoggers, final Consumer<Logger> finalConsumer) {
            if (!remaining.isEmpty()) {
                Logger logger = remaining.pop();
                logger.bulk(new Consumer<Logger>(){

                    public void accept(Logger bulkLogger) {
                        bulkLoggers.add(bulkLogger);
                        DuplicatingLogger.bulk(remaining, bulkLoggers, (Consumer<Logger>)finalConsumer);
                    }
                });
            } else {
                DuplicatingLogger logger = new DuplicatingLogger(bulkLoggers);
                finalConsumer.accept((Object)logger);
            }
        }
    }
}

