/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.function.Supplier;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLogProvider<T extends Log>
implements LogProvider {
    private final ConcurrentHashMap<String, T> logCache = new ConcurrentHashMap();

    public T getLog(final Class loggingClass) {
        return this.getLog(loggingClass.getName(), new Supplier<T>(){

            public T get() {
                return AbstractLogProvider.this.buildLog(loggingClass);
            }
        });
    }

    public T getLog(final String name) {
        return this.getLog(name, new Supplier<T>(){

            public T get() {
                return AbstractLogProvider.this.buildLog(name);
            }
        });
    }

    private T getLog(String name, Supplier<T> logSupplier) {
        Log newLog;
        Log log = (Log)this.logCache.get(name);
        if (log == null && (log = this.logCache.putIfAbsent(name, newLog = (Log)logSupplier.get())) == null) {
            log = newLog;
        }
        return (T)log;
    }

    protected Collection<T> cachedLogs() {
        return this.logCache.values();
    }

    protected abstract T buildLog(Class var1);

    protected abstract T buildLog(String var1);
}

