/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;

public interface ResourceLocker {
    public static final ResourceLocker PREVENT = new ResourceLocker(){

        @Override
        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            throw new UnsupportedOperationException("Unexpected call to lock a resource " + String.valueOf((Object)resourceType) + " " + resourceId);
        }

        @Override
        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
            throw new UnsupportedOperationException("Unexpected call to lock a resource " + String.valueOf((Object)resourceType) + " " + Arrays.toString(resourceIds));
        }

        @Override
        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
            throw new UnsupportedOperationException("Unexpected call to lock a resource " + String.valueOf((Object)resourceType) + " " + Arrays.toString(resourceIds));
        }

        @Override
        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
            throw new UnsupportedOperationException("Unexpected call to lock a resource " + String.valueOf((Object)resourceType) + " " + Arrays.toString(resourceIds));
        }

        @Override
        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
            throw new UnsupportedOperationException("Unexpected call to lock a resource " + String.valueOf((Object)resourceType) + " " + Arrays.toString(resourceIds));
        }

        @Override
        public Collection<ActiveLock> activeLocks() {
            return Collections.emptyList();
        }

        @Override
        public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
            return false;
        }
    };
    public static final ResourceLocker IGNORE = new ResourceLocker(){

        @Override
        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            return true;
        }

        @Override
        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public Collection<ActiveLock> activeLocks() {
            return Collections.emptyList();
        }

        @Override
        public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
            return false;
        }
    };

    public boolean tryExclusiveLock(ResourceType var1, long var2);

    public void acquireExclusive(LockTracer var1, ResourceType var2, long ... var3);

    public void releaseExclusive(ResourceType var1, long ... var2);

    public void acquireShared(LockTracer var1, ResourceType var2, long ... var3);

    public void releaseShared(ResourceType var1, long ... var2);

    public Collection<ActiveLock> activeLocks();

    public boolean holdsLock(long var1, ResourceType var3, LockType var4);
}

