/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.forseti.ExclusiveLock;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.locking.forseti.LockPath;
import org.neo4j.kernel.impl.locking.forseti.SharedLock;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

public class ForsetiClient
implements LockManager.Client {
    private static final int MAX_SPINS = 1000;
    private static final long MULTIPLY_UNTIL_ITERATION = 1002L;
    private static final int NO_CLIENT_ID = -1;
    private static final int NO_DEADLOCK_DEPTH = -1;
    private final ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps;
    private final HeapTrackingLongIntHashMap[] sharedLockCounts;
    private final HeapTrackingLongIntHashMap[] exclusiveLockCounts;
    private final AtomicLong activeLockCount = new AtomicLong();
    private long lockAcquisitionTimeoutNano;
    private final SystemNanoClock clock;
    private boolean verboseDeadlocks;
    private final Set<ForsetiClient> waitList = ConcurrentHashMap.newKeySet();
    private final LockClientStateHolder stateHolder = new LockClientStateHolder();
    private ExclusiveLock myExclusiveLock;
    private volatile boolean hasLocks;
    private final ReleaseExclusiveLocksAndClearSharedVisitor releaseExclusiveAndClearSharedVisitor = new ReleaseExclusiveLocksAndClearSharedVisitor();
    private final ReleaseSharedDontCheckExclusiveVisitor releaseSharedDontCheckExclusiveVisitor = new ReleaseSharedDontCheckExclusiveVisitor();
    private volatile ForsetiLockManager.Lock waitingForLock;
    private volatile ResourceType waitingForResourceType;
    private volatile long waitingForResourceId;
    private volatile LockType waitingForLockType;
    private volatile long transactionId;
    private final long clientId;
    private volatile DeferredScopedMemoryTracker memoryTracker;
    private static final long CONCURRENT_NODE_SIZE = (long)HeapEstimator.LONG_SIZE + HeapEstimator.HASH_MAP_NODE_SHALLOW_SIZE;
    private volatile long prepareThreadId;

    public ForsetiClient(ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps, SystemNanoClock clock, boolean verboseDeadlocks, long clientId) {
        this.lockMaps = lockMaps;
        this.sharedLockCounts = new HeapTrackingLongIntHashMap[lockMaps.length];
        this.exclusiveLockCounts = new HeapTrackingLongIntHashMap[lockMaps.length];
        this.clock = clock;
        this.verboseDeadlocks = verboseDeadlocks;
        this.clientId = clientId;
    }

    @Override
    public void initialize(LeaseClient leaseClient, long transactionId, MemoryTracker memoryTracker, Config config) {
        this.prepareThreadId = -1L;
        this.stateHolder.reset();
        this.transactionId = transactionId;
        this.memoryTracker = new DeferredScopedMemoryTracker(Objects.requireNonNull(memoryTracker));
        this.lockAcquisitionTimeoutNano = ((Duration)config.get(GraphDatabaseSettings.lock_acquisition_timeout)).toNanos();
        this.verboseDeadlocks = (Boolean)config.get(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks);
        this.myExclusiveLock = new ExclusiveLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        LockWaitEvent waitEvent = null;
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap heldShareLocks = this.getSharedLockCount(resourceType);
            HeapTrackingLongIntHashMap heldExclusiveLocks = this.getExclusiveLockCount(resourceType);
            for (long resourceId : resourceIds) {
                int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    continue;
                }
                this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
                int tries = 0;
                SharedLock mySharedLock = null;
                long waitStartNano = this.clock.nanos();
                while (true) {
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (mySharedLock == null) {
                            mySharedLock = new SharedLock(this);
                        }
                        if (lockMap.putIfAbsent(resourceId, mySharedLock) != null) continue;
                        break;
                    }
                    if (existingLock instanceof SharedLock) {
                        SharedLock sharedLock = (SharedLock)existingLock;
                        if (sharedLock.acquire(this)) {
                            break;
                        }
                    } else if (!(existingLock instanceof ExclusiveLock)) {
                        throw new UnsupportedOperationException("Unknown lock type: " + String.valueOf(existingLock));
                    }
                    if (waitEvent == null) {
                        waitEvent = tracer.waitForLock(LockType.SHARED, resourceType, this.transactionId, resourceId);
                    }
                    this.waitFor(existingLock, resourceType, resourceId, LockType.SHARED, tries++);
                }
                this.activeLockCount.incrementAndGet();
                heldShareLocks.put(resourceId, 1);
            }
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
                this.clearWaitState();
            }
            this.stateHolder.decrementActiveClients();
        }
    }

    private void noteWaitingForLock(ForsetiLockManager.Lock lock, ResourceType resourceType, long resourceId, LockType lockType) {
        this.waitingForResourceType = resourceType;
        this.waitingForResourceId = resourceId;
        this.waitingForLockType = lockType;
        this.waitingForLock = lock;
    }

    private void clearWaitState() {
        this.clearWaitList();
        this.waitingForLock = null;
        this.waitingForResourceId = -1L;
        this.waitingForResourceType = null;
        this.waitingForLockType = null;
    }

    private HeapTrackingLongIntHashMap getSharedLockCount(ResourceType resourceType) {
        HeapTrackingLongIntHashMap sharedLockCount = this.sharedLockCounts[resourceType.typeId()];
        if (sharedLockCount == null) {
            this.sharedLockCounts[resourceType.typeId()] = sharedLockCount = HeapTrackingCollections.newLongIntMap((MemoryTracker)this.memoryTracker);
        }
        return sharedLockCount;
    }

    private HeapTrackingLongIntHashMap getExclusiveLockCount(ResourceType resourceType) {
        HeapTrackingLongIntHashMap exclusiveLockCount = this.exclusiveLockCounts[resourceType.typeId()];
        if (exclusiveLockCount == null) {
            this.exclusiveLockCounts[resourceType.typeId()] = exclusiveLockCount = HeapTrackingCollections.newLongIntMap((MemoryTracker)this.memoryTracker);
        }
        return exclusiveLockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        LockWaitEvent waitEvent = null;
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap heldLocks = this.getExclusiveLockCount(resourceType);
            for (long resourceId : resourceIds) {
                ForsetiLockManager.Lock existingLock;
                int heldCount = heldLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
                int tries = 0;
                long waitStartNano = this.clock.nanos();
                boolean upgraded = false;
                while ((existingLock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock)) != null) {
                    SharedLock sharedLock;
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    if (existingLock instanceof SharedLock && this.tryUpgradeSharedToExclusive(tracer, waitEvent, resourceType, lockMap, resourceId, sharedLock = (SharedLock)existingLock, waitStartNano)) {
                        upgraded = true;
                        break;
                    }
                    if (waitEvent == null) {
                        waitEvent = tracer.waitForLock(LockType.EXCLUSIVE, resourceType, this.transactionId, resourceId);
                    }
                    this.waitFor(existingLock, resourceType, resourceId, LockType.EXCLUSIVE, tries++);
                }
                if (upgraded) {
                    this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
                } else {
                    this.activeLockCount.incrementAndGet();
                }
                heldLocks.put(resourceId, 1);
            }
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
                this.clearWaitState();
            }
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap heldLocks = this.getExclusiveLockCount(resourceType);
            int heldCount = heldLocks.getIfAbsent(resourceId, -1);
            if (heldCount != -1) {
                heldLocks.put(resourceId, Math.incrementExact(heldCount));
                boolean bl = true;
                return bl;
            }
            this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            ForsetiLockManager.Lock lock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock);
            if (lock != null) {
                if (lock instanceof SharedLock) {
                    SharedLock sharedLock = (SharedLock)lock;
                    if (this.getSharedLockCount(resourceType).containsKey(resourceId) && sharedLock.tryAcquireUpdateLock()) {
                        if (sharedLock.numberOfHolders() == 1) {
                            heldLocks.put(resourceId, 1);
                            boolean bl = true;
                            return bl;
                        }
                        sharedLock.releaseUpdateLock();
                        this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
                        boolean bl = false;
                        return bl;
                    }
                }
                this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
                boolean bl = false;
                return bl;
            }
            this.activeLockCount.incrementAndGet();
            heldLocks.put(resourceId, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients(this);
        try {
            HeapTrackingLongIntHashMap heldShareLocks;
            block12: {
                ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
                heldShareLocks = this.getSharedLockCount(resourceType);
                HeapTrackingLongIntHashMap heldExclusiveLocks = this.getExclusiveLockCount(resourceType);
                int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    boolean bl = true;
                    return bl;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    boolean bl = true;
                    return bl;
                }
                this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
                long waitStartNano = this.clock.nanos();
                while (true) {
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (lockMap.putIfAbsent(resourceId, new SharedLock(this)) != null) continue;
                        break block12;
                    }
                    if (!(existingLock instanceof SharedLock)) {
                        if (!(existingLock instanceof ExclusiveLock)) throw new UnsupportedOperationException("Unknown lock type: " + String.valueOf(existingLock));
                        this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
                        boolean bl = false;
                        return bl;
                    }
                    SharedLock sharedLock = (SharedLock)existingLock;
                    if (sharedLock.acquire(this)) break block12;
                    if (sharedLock.isUpdateLock()) break;
                }
                this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
                boolean bl = false;
                return bl;
            }
            this.activeLockCount.incrementAndGet();
            heldShareLocks.put(resourceId, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            HeapTrackingLongIntHashMap sharedLocks = this.getSharedLockCount(resourceType);
            HeapTrackingLongIntHashMap exclusiveLocks = this.getExclusiveLockCount(resourceType);
            ConcurrentMap<Long, ForsetiLockManager.Lock> resourceTypeLocks = this.lockMaps[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                if (this.releaseLocalLock(resourceType, resourceId, sharedLocks) || exclusiveLocks.containsKey(resourceId)) continue;
                this.releaseGlobalLock(resourceTypeLocks, resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> resourceTypeLocks = this.lockMaps[resourceType.typeId()];
            HeapTrackingLongIntHashMap exclusiveLocks = this.getExclusiveLockCount(resourceType);
            HeapTrackingLongIntHashMap sharedLocks = this.getSharedLockCount(resourceType);
            for (long resourceId : resourceIds) {
                if (this.releaseLocalLock(resourceType, resourceId, exclusiveLocks)) continue;
                if (sharedLocks.containsKey(resourceId)) {
                    ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)resourceTypeLocks.get(resourceId);
                    if (lock instanceof SharedLock) {
                        SharedLock sharedLock = (SharedLock)lock;
                        if (sharedLock.isUpdateLock()) {
                            sharedLock.releaseUpdateLock();
                            continue;
                        }
                        throw new IllegalStateException("Incorrect state of exclusive lock. Lock should be updated to exclusive before attempt to release it. Lock: " + String.valueOf(this));
                    }
                    SharedLock sharedLock = new SharedLock(this);
                    resourceTypeLocks.put(resourceId, sharedLock);
                    continue;
                }
                this.releaseGlobalLock(resourceTypeLocks, resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private void releaseAllClientLocks() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            HeapTrackingLongIntHashMap exclusiveLocks = this.exclusiveLockCounts[i];
            HeapTrackingLongIntHashMap sharedLocks = this.sharedLockCounts[i];
            if (exclusiveLocks != null) {
                exclusiveLocks.forEachKey(this.releaseExclusiveAndClearSharedVisitor.initialize(sharedLocks, this.lockMaps[i]));
                this.exclusiveLockCounts[i] = null;
                exclusiveLocks.close();
            }
            if (sharedLocks == null) continue;
            sharedLocks.forEachKey(this.releaseSharedDontCheckExclusiveVisitor.initialize(this.lockMaps[i]));
            this.sharedLockCounts[i] = null;
            sharedLocks.close();
        }
        this.activeLockCount.set(0L);
    }

    @Override
    public void prepareForCommit() {
        this.prepareThreadId = Thread.currentThread().getId();
        this.stateHolder.prepare(this);
    }

    @Override
    public void stop() {
        this.stateHolder.incrementActiveClients(this);
        try {
            if (this.stateHolder.stopClient()) {
                this.waitForStopBeOnlyClient();
                this.memoryTracker.stop();
                this.releaseAllLocks();
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private void waitForStopBeOnlyClient() {
        while (!this.stateHolder.isSingleClient()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private void waitForAllClientsToLeave() {
        while (this.stateHolder.hasActiveClients()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    @Override
    public void close() {
        this.stateHolder.closeClient();
        this.waitForAllClientsToLeave();
        this.releaseAllLocks();
        this.transactionId = -1L;
        this.memoryTracker.close();
        this.myExclusiveLock.close();
    }

    private void releaseAllLocks() {
        if (this.hasLocks) {
            this.releaseAllClientLocks();
            this.clearWaitList();
            this.hasLocks = false;
        }
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Collection<ActiveLock> activeLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>();
        for (int typeId = 0; typeId < this.lockMaps.length; ++typeId) {
            ResourceType resourceType = ResourceType.fromId(typeId);
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[typeId];
            if (lockMap == null) continue;
            lockMap.forEach((resourceId, lock) -> {
                if (lock.isOwnedBy(this)) {
                    locks.add(new ActiveLock(resourceType, lock.type(), this.transactionId, (long)resourceId));
                }
            });
        }
        return locks;
    }

    @Override
    public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
        ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resource.typeId()];
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(id);
        if (lock == null) {
            return false;
        }
        LockType type = lock.type();
        return lock.isOwnedBy(this) && (type == lockType || type == LockType.EXCLUSIVE);
    }

    @Override
    public long activeLockCount() {
        return this.activeLockCount.get();
    }

    @Override
    public void reset() {
        this.releaseAllLocks();
    }

    void copyWaitListTo(Set<ForsetiClient> other) {
        other.add(this);
        other.addAll(this.waitList);
    }

    boolean isWaitingFor(ForsetiClient client) {
        return client.getTransactionId() != this.getTransactionId() && this.waitList.contains(client);
    }

    boolean isWaitingFor(ForsetiLockManager.Lock lock, ResourceType resourceType, long resourceId) {
        return this.waitingForLock == lock && this.waitingForResourceType == resourceType && this.waitingForResourceId == resourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForsetiClient that = (ForsetiClient)o;
        return this.clientId == that.clientId;
    }

    public int hashCode() {
        return Long.hashCode(this.clientId);
    }

    public String toString() {
        return String.format("ForsetiClient[transactionId=%d, clientId=%d]", this.transactionId, this.clientId);
    }

    private void releaseGlobalLock(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId) {
        SharedLock sharedLock;
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
        if (lock instanceof ExclusiveLock) {
            lockMap.remove(resourceId);
            this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
        } else if (lock instanceof SharedLock && (sharedLock = (SharedLock)lock).release(this)) {
            lockMap.remove(resourceId);
            this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
        }
        this.activeLockCount.decrementAndGet();
    }

    private boolean releaseLocalLock(ResourceType type, long resourceId, HeapTrackingLongIntHashMap localLocks) {
        int lockCount = localLocks.removeKeyIfAbsent(resourceId, -1);
        if (lockCount == -1) {
            throw new IllegalStateException(String.valueOf(this) + " cannot release lock that it does not hold: " + String.valueOf((Object)type) + "[" + resourceId + "].");
        }
        if (lockCount > 1) {
            localLocks.put(resourceId, lockCount - 1);
            return true;
        }
        return false;
    }

    private boolean tryUpgradeSharedToExclusive(LockTracer tracer, LockWaitEvent waitEvent, ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock, long waitStartNano) {
        int tries = 0;
        boolean holdsSharedLock = this.getSharedLockCount(resourceType).containsKey(resourceId);
        if (!holdsSharedLock) {
            this.memoryTracker.allocateHeap(CONCURRENT_NODE_SIZE);
            if (!sharedLock.acquire(this)) {
                this.memoryTracker.releaseHeap(CONCURRENT_NODE_SIZE);
                return false;
            }
            this.activeLockCount.incrementAndGet();
            try {
                if (this.tryUpgradeToExclusiveWithShareLockHeld(tracer, waitEvent, resourceType, resourceId, sharedLock, tries, waitStartNano)) {
                    return true;
                }
                this.releaseGlobalLock(lockMap, resourceId);
                return false;
            }
            catch (Throwable e) {
                this.releaseGlobalLock(lockMap, resourceId);
                throw e;
            }
        }
        return this.tryUpgradeToExclusiveWithShareLockHeld(tracer, waitEvent, resourceType, resourceId, sharedLock, tries, waitStartNano);
    }

    private boolean tryUpgradeToExclusiveWithShareLockHeld(LockTracer tracer, LockWaitEvent priorEvent, ResourceType resourceType, long resourceId, SharedLock sharedLock, int tries, long waitStartNano) {
        if (sharedLock.tryAcquireUpdateLock()) {
            LockWaitEvent waitEvent = null;
            try {
                while (sharedLock.numberOfHolders() > 1) {
                    this.assertValid(waitStartNano, resourceType, resourceId);
                    if (waitEvent == null && priorEvent == null) {
                        waitEvent = tracer.waitForLock(LockType.EXCLUSIVE, resourceType, this.transactionId, resourceId);
                    }
                    this.waitFor(sharedLock, resourceType, resourceId, LockType.EXCLUSIVE, tries++);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                Status.Database database;
                sharedLock.releaseUpdateLock();
                if (e instanceof DeadlockDetectedException || e instanceof LockClientStoppedException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Status.HasStatus) {
                    Status.HasStatus se = (Status.HasStatus)e;
                    database = se.status();
                } else {
                    database = Status.Database.Unknown;
                }
                Status.Database status = database;
                throw new TransactionFailureException("Failed to upgrade shared lock to exclusive: " + String.valueOf(sharedLock), e, (Status)status);
            }
            finally {
                if (waitEvent != null) {
                    waitEvent.close();
                    this.clearWaitState();
                }
            }
        }
        return false;
    }

    private void clearWaitList() {
        this.waitList.clear();
    }

    private void waitFor(ForsetiLockManager.Lock lock, ResourceType type, long resourceId, LockType lockType, int tries) {
        this.clearAndCopyWaitList(lock);
        this.noteWaitingForLock(lock, type, resourceId, lockType);
        ForsetiClient.incrementalBackoffWait(tries);
        ForsetiClient clientId = lock.detectDeadlock(this);
        if (clientId != null && this.shouldAbort(clientId)) {
            int depth;
            if (tries > 100 && (depth = this.isDeadlockReal(lock)) != -1) {
                if (this.verboseDeadlocks) {
                    String deadlockCycleMessage = this.findDeadlockPath(lock, type, resourceId, depth);
                    if (deadlockCycleMessage != null) {
                        String message = String.format("%s can't acquire %s %s because it would form this deadlock wait cycle:%n%s", new Object[]{this, lockType, ForsetiClient.lockString(type, resourceId), deadlockCycleMessage});
                        throw DeadlockDetectedException.deadlockDetected(message);
                    }
                } else {
                    throw DeadlockDetectedException.deadlockDetected(String.format("%s can't acquire %s on %s because holders of that lock are waiting for %s.%n Wait list:%s", this, lock, ForsetiClient.lockString(type, resourceId), this, lock.describeWaitList()));
                }
            }
            Thread.yield();
        } else if ((tries & 0x1FFF) == 8191) {
            for (ForsetiClient client : this.waitList) {
                if (!this.clientCommittingByCurrentThread(client) || this.isDeadlockReal(lock) == -1) continue;
                String message = String.valueOf(this) + " can't acquire " + String.valueOf(lock) + " on " + String.valueOf((Object)type) + "(" + resourceId + "), because we are waiting for " + String.valueOf(client) + " that is committing on the same thread";
                throw DeadlockDetectedException.deadlockDetected(message);
            }
        }
    }

    @VisibleForTesting
    public static void incrementalBackoffWait(long iteration) {
        if (iteration < 1000L) {
            Thread.onSpinWait();
            return;
        }
        try {
            if (iteration < 1002L) {
                LockSupport.parkNanos(500L);
            } else {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new LockAcquisitionTimeoutException((Status)Status.Transaction.Interrupted, "Interrupted while waiting.");
        }
    }

    private boolean shouldAbort(ForsetiClient clientWereDeadlockedWith) {
        long otherCount;
        if (this.getTransactionId() == clientWereDeadlockedWith.getTransactionId()) {
            return true;
        }
        long ourCount = this.activeLockCount();
        if (ourCount > (otherCount = clientWereDeadlockedWith.activeLockCount())) {
            return false;
        }
        if (otherCount > ourCount) {
            return true;
        }
        return this.getTransactionId() > clientWereDeadlockedWith.getTransactionId();
    }

    private boolean clientCommittingByCurrentThread(ForsetiClient otherClient) {
        return otherClient != this && otherClient.stateHolder.isPrepared() && Thread.currentThread().getId() == otherClient.prepareThreadId;
    }

    private void clearAndCopyWaitList(ForsetiLockManager.Lock lock) {
        this.clearWaitList();
        lock.copyHolderWaitListsInto(this.waitList);
    }

    private int isDeadlockReal(ForsetiLockManager.Lock lock) {
        if (this.isDeadlockRealInternal(lock) != -1) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            return this.isDeadlockRealInternal(lock);
        }
        return -1;
    }

    private int isDeadlockRealInternal(ForsetiLockManager.Lock lock) {
        HashSet<ForsetiLockManager.Lock> waitedUpon = new HashSet<ForsetiLockManager.Lock>();
        HashSet<ForsetiClient> owners = new HashSet<ForsetiClient>();
        HashSet<ForsetiLockManager.Lock> nextWaitedUpon = new HashSet<ForsetiLockManager.Lock>();
        HashSet<ForsetiClient> nextOwners = new HashSet<ForsetiClient>();
        lock.collectOwners(owners);
        int depth = 1;
        do {
            ++depth;
            waitedUpon.addAll(nextWaitedUpon);
            boolean foundSameThreadClientCycle = this.collectNextOwners(waitedUpon, owners, nextWaitedUpon, nextOwners);
            if (foundSameThreadClientCycle || nextOwners.contains(this) && lock.detectDeadlock(this) != null) {
                return depth;
            }
            owners.clear();
            HashSet<ForsetiClient> ownersTmp = owners;
            owners = nextOwners;
            nextOwners = ownersTmp;
        } while (!nextWaitedUpon.isEmpty());
        return -1;
    }

    private String findDeadlockPath(ForsetiLockManager.Lock lockToWaitFor, ResourceType type, long resourceId, int maxDepth) {
        ArrayList<LockPath> parents = new ArrayList<LockPath>();
        HashSet<ForsetiClient> owners = new HashSet<ForsetiClient>();
        ArrayList<LockPath> paths = new ArrayList<LockPath>();
        this.traverseOneStep(null, lockToWaitFor, parents, 0, owners);
        for (int depth = 1; depth <= maxDepth + 1; ++depth) {
            for (LockPath parentPath : parents) {
                LockPath path;
                ForsetiLockManager.Lock lock = parentPath.ownerWaitingForLock();
                if (lock.isClosed() || (path = this.traverseOneStep(parentPath, lock, paths, depth, owners)) == null) continue;
                return path.stringify(lockToWaitFor, type, resourceId);
            }
            parents = paths;
            paths = new ArrayList();
        }
        return null;
    }

    static String lockString(ResourceType resourceType, long resourceId) {
        return String.format("%s(%d)", new Object[]{resourceType, resourceId});
    }

    private LockPath traverseOneStep(LockPath parentPath, ForsetiLockManager.Lock lock, List<LockPath> paths, int depth, Set<ForsetiClient> owners) {
        owners.clear();
        lock.collectOwners(owners);
        for (ForsetiClient owner : owners) {
            ForsetiLockManager.Lock ownerWaitingForLock = owner.waitingForLock;
            ResourceType ownerWaitingForResourceType = owner.waitingForResourceType;
            long ownerWaitingForResourceId = owner.waitingForResourceId;
            LockType ownerWaitingForLockType = owner.waitingForLockType;
            long ownerTransactionId = owner.transactionId;
            if (ownerWaitingForLock == null || ownerWaitingForResourceType == null || ownerWaitingForLock.isClosed() || parentPath != null && parentPath.containsOwner(ownerTransactionId)) continue;
            LockPath path = new LockPath(owner, ownerTransactionId, ownerWaitingForLock, ownerWaitingForResourceType, ownerWaitingForResourceId, ownerWaitingForLockType, parentPath);
            if (owner == this && depth > 0) {
                return path;
            }
            paths.add(path);
        }
        return null;
    }

    private boolean collectNextOwners(Set<ForsetiLockManager.Lock> waitedUpon, Set<ForsetiClient> owners, Set<ForsetiLockManager.Lock> nextWaitedUpon, Set<ForsetiClient> nextOwners) {
        nextWaitedUpon.clear();
        for (ForsetiClient owner : owners) {
            if (this.clientCommittingByCurrentThread(owner)) {
                return true;
            }
            ForsetiLockManager.Lock waitingForLock = owner.waitingForLock;
            if (waitingForLock == null || waitingForLock.isClosed() || waitedUpon.contains(waitingForLock)) continue;
            nextWaitedUpon.add(waitingForLock);
        }
        for (ForsetiLockManager.Lock lck : nextWaitedUpon) {
            lck.collectOwners(nextOwners);
        }
        return false;
    }

    String describeWaitList() {
        StringBuilder sb = new StringBuilder(String.format("%nClient[%d] waits for [", this.getTransactionId()));
        Iterator<ForsetiClient> iter = this.waitList.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            ForsetiClient next = iter.next();
            if (next.getTransactionId() == this.getTransactionId()) continue;
            sb.append(!first ? "," : "").append(next);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    private void assertValid(long waitStartNano, ResourceType resourceType, long resourceId) {
        this.assertNotStopped();
        this.assertNotExpired(waitStartNano, resourceType, resourceId);
    }

    private void assertNotStopped() {
        if (this.stateHolder.isStopped()) {
            throw new LockClientStoppedException(this);
        }
    }

    private void assertNotExpired(long waitStartNano, ResourceType resourceType, long resourceId) {
        long timeoutNano = this.lockAcquisitionTimeoutNano;
        if (timeoutNano > 0L && this.clock.nanos() - waitStartNano > timeoutNano) {
            throw new LockAcquisitionTimeoutException(resourceType, resourceId, timeoutNano);
        }
    }

    public long transactionId() {
        return this.transactionId;
    }

    private class ReleaseExclusiveLocksAndClearSharedVisitor
    implements LongProcedure {
        private HeapTrackingLongIntHashMap sharedLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseExclusiveLocksAndClearSharedVisitor() {
        }

        private LongProcedure initialize(HeapTrackingLongIntHashMap sharedLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.sharedLockCounts = sharedLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public void value(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            if (this.sharedLockCounts != null) {
                this.sharedLockCounts.remove(resourceId);
            }
        }
    }

    private class ReleaseSharedDontCheckExclusiveVisitor
    implements LongProcedure {
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseSharedDontCheckExclusiveVisitor() {
        }

        private LongProcedure initialize(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.lockMap = lockMap;
            return this;
        }

        public void value(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
        }
    }

    private static class DeferredScopedMemoryTracker
    extends DefaultScopedMemoryTracker {
        private boolean stopped;

        DeferredScopedMemoryTracker(MemoryTracker delegate) {
            super(delegate);
        }

        public void releaseHeap(long bytes) {
            if (!this.stopped) {
                super.releaseHeap(bytes);
            }
        }

        public void releaseNative(long bytes) {
            if (!this.stopped) {
                super.releaseNative(bytes);
            }
        }

        void stop() {
            this.stopped = true;
        }
    }
}

