/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.lock.AcquireLockTimeoutException;
import org.neo4j.lock.WaitStrategy;

public enum LockWaitStrategies implements WaitStrategy
{
    SPIN{

        @Override
        public void apply(long iteration) throws AcquireLockTimeoutException {
            Thread.onSpinWait();
        }
    }
    ,
    YIELD{

        @Override
        public void apply(long iteration) throws AcquireLockTimeoutException {
            Thread.yield();
        }
    }
    ,
    INCREMENTAL_BACKOFF{
        private static final int spinIterations = 1000;
        private static final long multiplyUntilIteration = 1002L;

        @Override
        public void apply(long iteration) throws AcquireLockTimeoutException {
            if (iteration < 1000L) {
                SPIN.apply(iteration);
                return;
            }
            try {
                if (iteration < 1002L) {
                    Thread.sleep(1L);
                } else {
                    LockSupport.parkNanos(500L);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new AcquireLockTimeoutException("Interrupted while waiting.", e, (Status)Status.Transaction.Interrupted);
            }
        }
    }
    ,
    NO_WAIT{

        @Override
        public void apply(long iteration) throws AcquireLockTimeoutException {
            throw new AcquireLockTimeoutException("Cannot acquire lock, and refusing to wait.", (Status)Status.Transaction.DeadlockDetected);
        }
    };

}

