/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class PlainDatabaseLayout
implements DatabaseLayout {
    private static final String DATABASE_LOCK_FILENAME = "database_lock";
    private static final String BACKUP_TOOLS_FOLDER = "tools";
    private static final String QUARANTINE_MARKER_FILENAME = "quarantine_marker";
    private final Path databaseDirectory;
    private final Neo4jLayout neo4jLayout;
    private final String databaseName;

    protected PlainDatabaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        String normalizedName = new NormalizedDatabaseName(databaseName).name();
        this.neo4jLayout = neo4jLayout;
        this.databaseDirectory = FileUtils.getCanonicalFile((Path)neo4jLayout.databasesDirectory().resolve(normalizedName));
        this.databaseName = normalizedName;
    }

    @Override
    public Path getTransactionLogsDirectory() {
        return this.neo4jLayout.transactionLogsRootDirectory().resolve(this.getDatabaseName());
    }

    @Override
    public Path getScriptDirectory() {
        return this.neo4jLayout.scriptRootDirectory().resolve(this.getDatabaseName());
    }

    @Override
    public Path databaseLockFile() {
        return this.databaseDirectory().resolve(DATABASE_LOCK_FILENAME);
    }

    @Override
    public Path quarantineFile() {
        return this.databaseDirectory().resolve(QUARANTINE_MARKER_FILENAME);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public Neo4jLayout getNeo4jLayout() {
        return this.neo4jLayout;
    }

    @Override
    public Path databaseDirectory() {
        return this.databaseDirectory;
    }

    @Override
    public Path backupToolsFolder() {
        return this.databaseDirectory().resolve(BACKUP_TOOLS_FOLDER);
    }

    @Override
    public Path metadataStore() {
        throw new IllegalStateException("Can not get the metadata store for a PlainDatabaseLayout.");
    }

    @Override
    public Path pathForExistsMarker() {
        throw new IllegalStateException("Can not get the exists marker path for a PlainDatabaseLayout.");
    }

    @Override
    public Path pathForStore(CommonDatabaseStores store) {
        throw new IllegalStateException("Can not get the path for the %s store from a PlainDatabaseLayout.".formatted(store.name()));
    }

    @Override
    public Set<Path> idFiles() {
        return this.databaseFiles().filter(DatabaseFile::hasIdFile).flatMap(value -> this.idFile((DatabaseFile)value).stream()).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<Path> storeFiles() {
        return this.databaseFiles().map(this::file).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<Path> mandatoryStoreFiles() {
        return this.databaseFiles().filter(Predicate.not(this::isRecoverableStore)).map(this::file).collect(Collectors.toUnmodifiableSet());
    }

    protected Stream<? extends DatabaseFile> databaseFiles() {
        throw new IllegalStateException("Can not access the database files from a PlainDatabaseLayout.");
    }

    @Override
    public Optional<Path> idFile(DatabaseFile file) {
        return file.hasIdFile() ? Optional.of(this.idFile(file.getName())) : Optional.empty();
    }

    @Override
    public Path file(String fileName) {
        return this.databaseDirectory.resolve(fileName);
    }

    @Override
    public Path file(DatabaseFile databaseFile) {
        return this.file(databaseFile.getName());
    }

    @Override
    public Stream<Path> allFiles(DatabaseFile databaseFile) {
        return Stream.concat(this.idFile(databaseFile).stream(), Stream.of(this.file(databaseFile)));
    }

    @Override
    public Path[] listDatabaseFiles(FileSystemAbstraction fs, Predicate<? super Path> filter) {
        try {
            return fs.listFiles(this.databaseDirectory, filter::test);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected Path idFile(String name) {
        return this.file(PlainDatabaseLayout.idFileName(name));
    }

    protected boolean isRecoverableStore(DatabaseFile file) {
        throw new IllegalStateException("Can not determine whether the store '%s' is recoverable in a PlainDatabaseLayout".formatted(file.getName()));
    }

    private static String idFileName(String storeName) {
        return storeName + ".id";
    }

    public int hashCode() {
        return Objects.hash(this.databaseDirectory, this.neo4jLayout);
    }

    public String toString() {
        return "PlainDatabaseLayout{databaseDirectory=" + this.databaseDirectory + ", transactionLogsDirectory=" + this.getTransactionLogsDirectory() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlainDatabaseLayout that = (PlainDatabaseLayout)o;
        return Objects.equals(this.databaseDirectory, that.databaseDirectory) && Objects.equals(this.neo4jLayout, that.neo4jLayout) && this.getTransactionLogsDirectory().equals(that.getTransactionLogsDirectory());
    }
}

