/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.PlainDatabaseLayout;

public interface DatabaseLayout {
    public static DatabaseLayout ofFlat(Path databaseDirectory) {
        Path canonical = FileUtils.getCanonicalFile((Path)databaseDirectory);
        Path home = canonical.getParent();
        String dbName = canonical.getFileName().toString();
        return Neo4jLayout.ofFlat(home).databaseLayout(dbName);
    }

    public static DatabaseLayout of(Config config) {
        return Neo4jLayout.of((Configuration)config).databaseLayout((String)config.get(GraphDatabaseSettings.initial_default_database));
    }

    public static DatabaseLayout of(Neo4jLayout neo4jLayout, String databaseName) {
        return new PlainDatabaseLayout(neo4jLayout, databaseName);
    }

    public Path getTransactionLogsDirectory();

    public Path getScriptDirectory();

    public Path databaseLockFile();

    public Path quarantineMarkerFile();

    public String getDatabaseName();

    public Neo4jLayout getNeo4jLayout();

    public Path databaseDirectory();

    public Path backupToolsFolder();

    public Path metadataStore();

    public Path pathForExistsMarker();

    public Path pathForStore(CommonDatabaseStores var1);

    public Set<Path> idFiles();

    public Set<Path> storeFiles();

    public Set<Path> mandatoryStoreFiles();

    public Optional<Path> idFile(DatabaseFile var1);

    public Path file(String var1);

    public Path file(DatabaseFile var1);

    public Stream<Path> allFiles(DatabaseFile var1);

    public Path[] listDatabaseFiles(FileSystemAbstraction var1, Predicate<? super Path> var2);
}

