/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.util.Objects;
import java.util.Optional;

public enum DatabaseFile {
    NODE_STORE("neostore.nodestore.db"),
    NODE_LABEL_STORE("neostore.nodestore.db.labels"),
    PROPERTY_STORE("neostore.propertystore.db"),
    PROPERTY_ARRAY_STORE("neostore.propertystore.db.arrays"),
    PROPERTY_STRING_STORE("neostore.propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE("neostore.propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("neostore.propertystore.db.index.keys"),
    RELATIONSHIP_STORE("neostore.relationshipstore.db"),
    RELATIONSHIP_GROUP_STORE("neostore.relationshipgroupstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE("neostore.relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("neostore.relationshiptypestore.db.names"),
    LABEL_TOKEN_STORE("neostore.labeltokenstore.db"),
    LABEL_TOKEN_NAMES_STORE("neostore.labeltokenstore.db.names"),
    SCHEMA_STORE("neostore.schemastore.db"),
    COUNTS_STORE("neostore.counts.db", false),
    RELATIONSHIP_GROUP_DEGREES_STORE("neostore.relationshipgroupstore.degrees.db", false),
    METADATA_STORE("neostore", false),
    INDEX_STATISTICS_STORE("neostore.indexstats.db", false),
    LABEL_SCAN_STORE("neostore.labelscanstore.db", false),
    RELATIONSHIP_TYPE_SCAN_STORE("neostore.relationshiptypescanstore.db", false);

    private final String name;
    private final boolean hasIdFile;

    private DatabaseFile(String name) {
        this(name, true);
    }

    private DatabaseFile(String name, boolean hasIdFile) {
        this.name = name;
        this.hasIdFile = hasIdFile;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasIdFile() {
        return this.hasIdFile;
    }

    public static Optional<DatabaseFile> fileOf(String name) {
        DatabaseFile[] databaseFiles;
        Objects.requireNonNull(name);
        for (DatabaseFile databaseFile : databaseFiles = DatabaseFile.values()) {
            if (!databaseFile.name.equals(name)) continue;
            return Optional.of(databaseFile);
        }
        return Optional.empty();
    }
}

