/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;

public final class Neo4jLayout {
    private static final String STORE_LOCK_FILENAME = "store_lock";
    private final File homeDirectory;
    private final File databasesRootDirectory;
    private final File txLogsRootDirectory;

    public static Neo4jLayout of(File homeDirectory) {
        File canonicalHome = FileUtils.getCanonicalFile((File)homeDirectory);
        return Neo4jLayout.of(Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)canonicalHome.toPath().toAbsolutePath()));
    }

    public static Neo4jLayout of(Config config) {
        File homeDirectory = ((Path)config.get(GraphDatabaseSettings.neo4j_home)).toFile();
        File databasesRootDirectory = ((Path)config.get(GraphDatabaseInternalSettings.databases_root_path)).toFile();
        File txLogsRootDirectory = ((Path)config.get(GraphDatabaseSettings.transaction_logs_root_path)).toFile();
        return new Neo4jLayout(homeDirectory, databasesRootDirectory, txLogsRootDirectory);
    }

    public static Neo4jLayout ofFlat(File homeDirectory) {
        Path home = homeDirectory.toPath().toAbsolutePath();
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)home).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)home).set(GraphDatabaseInternalSettings.databases_root_path, (Object)home).build();
        return Neo4jLayout.of(config);
    }

    private Neo4jLayout(File homeDirectory, File databasesRootDirectory, File txLogsRootDirectory) {
        this.homeDirectory = FileUtils.getCanonicalFile((File)homeDirectory);
        this.databasesRootDirectory = FileUtils.getCanonicalFile((File)databasesRootDirectory);
        this.txLogsRootDirectory = FileUtils.getCanonicalFile((File)txLogsRootDirectory);
    }

    public Collection<DatabaseLayout> databaseLayouts() {
        Object[] directories = this.databasesRootDirectory.listFiles(File::isDirectory);
        if (ArrayUtils.isEmpty((Object[])directories)) {
            return Collections.emptyList();
        }
        return Arrays.stream(directories).map(directory -> DatabaseLayout.of(this, directory.getName())).collect(Collectors.toList());
    }

    public DatabaseLayout databaseLayout(String databaseName) {
        return DatabaseLayout.of(this, databaseName);
    }

    public File databasesDirectory() {
        return this.databasesRootDirectory;
    }

    public File homeDirectory() {
        return this.homeDirectory;
    }

    public File transactionLogsRootDirectory() {
        return this.txLogsRootDirectory;
    }

    public File storeLockFile() {
        return new File(this.databasesRootDirectory, STORE_LOCK_FILENAME);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Neo4jLayout that = (Neo4jLayout)o;
        return Objects.equals(this.homeDirectory, that.homeDirectory) && Objects.equals(this.databasesRootDirectory, that.databasesRootDirectory) && Objects.equals(this.txLogsRootDirectory, that.txLogsRootDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.homeDirectory, this.databasesRootDirectory, this.txLogsRootDirectory);
    }

    public String toString() {
        return String.format("Neo4JLayout{ homeDir=%s, databasesDir=%s, txLogsRootDir=%s}", this.homeDirectory.toString(), this.databasesRootDirectory.toString(), this.txLogsRootDirectory.toString());
    }
}

