/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.AppendTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.TransactionIdStore;

class BatchingTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final Panic databasePanic;
    private TransactionLogWriter transactionLogWriter;
    private int previousChecksum;

    BatchingTransactionAppender(LogFiles logFiles, TransactionIdStore transactionIdStore, Panic databasePanic) {
        this.logFile = logFiles.getLogFile();
        this.logRotation = this.logFile.getLogRotation();
        this.databasePanic = databasePanic;
        this.previousChecksum = transactionIdStore.getLastCommittedTransaction().checksum();
    }

    public void start() {
        this.transactionLogWriter = this.logFile.getTransactionLogWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(CommandBatchToApply batch, LogAppendEvent logAppendEvent) throws IOException {
        long lastTransactionId = 1L;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.databasePanic.assertNoPanic(IOException.class);
            try (AppendTransactionEvent appendEvent = logAppendEvent.beginAppendTransaction(1);){
                for (CommandBatchToApply commands = batch; commands != null; commands = commands.next()) {
                    long transactionId = commands.transactionId();
                    this.appendToLog(commands, transactionId, logAppendEvent);
                    lastTransactionId = transactionId;
                }
            }
        }
        if (this.logFile.forceAfterAppend(logAppendEvent)) {
            boolean logRotated = this.logRotation.rotateLogIfNeeded(logAppendEvent);
            logAppendEvent.setLogRotated(logRotated);
        }
        BatchingTransactionAppender.publishAsCommitted(batch);
        return lastTransactionId;
    }

    private static void publishAsCommitted(CommandBatchToApply batch) {
        while (batch != null) {
            batch.commit();
            batch = batch.next();
        }
    }

    private void appendToLog(CommandBatchToApply commands, long transactionId, LogAppendEvent logAppendEvent) throws IOException {
        try {
            LogPosition logPositionBeforeCommit = this.transactionLogWriter.getCurrentPosition();
            this.previousChecksum = this.transactionLogWriter.append(commands.commandBatch(), transactionId, commands.chunkId(), this.previousChecksum, commands.previousBatchLogPosition());
            LogPosition logPositionAfterCommit = this.transactionLogWriter.getCurrentPosition();
            logAppendEvent.appendToLogFile(logPositionBeforeCommit, logPositionAfterCommit);
            commands.batchAppended(logPositionBeforeCommit, logPositionAfterCommit, this.previousChecksum);
        }
        catch (Throwable panic) {
            this.databasePanic.panic(panic);
            throw panic;
        }
    }
}

